/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPHashJoin;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XHashJoin;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class GenerateXHashJoin
extends RQETransformation {
    public GenerateXHashJoin() {
        this.mName = "Generate XHashJoin node.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{901015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        QEPHashJoin plan = (QEPHashJoin)node;
        XHashJoin xJoin = (XHashJoin)nodeFactory.createXNode(501009);
        xJoin.setJoinType(plan.getJoinType());
        xJoin.setJoins(plan.getJoins());
        node.exchange(xJoin, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XJoin.JoinType joinType = ((QEPJoin)node).getJoinType();
        boolean bl = status = joinType != XJoin.JoinType.ANTI && joinType != XJoin.JoinType.SEMI;
        if (status) {
            this.traceQueryCondition(status, "Join plan is not a hash anti-join or hash semi-join plan.", trace);
        } else {
            this.traceQueryCondition(status, "Join plan is a hash anti-join or hash semi-join plan.", trace);
        }
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }
}

