/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.ArrayList;
import java.util.LinkedList;

public final class GenerateXTableFunction
extends RQETransformation {
    public GenerateXTableFunction() {
        this.mName = "Generate XTableFunction node.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{301038};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        GenerateXTableFunction.doTransformation(node, environment);
    }

    public static void doTransformation(IXQEQueryNode node, IPlanningEnvironment environment) {
        XValueDecoration valueDecorationNode;
        XNode subTree;
        RowType rowType;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLTableFunction fNode = (SQLTableFunction)node;
        IFunction function = fNode.getFunction();
        if (null == function) {
            int nChildren = fNode.getNumberChildren();
            LinkedList<IDataType> argumentTypes = new LinkedList<IDataType>();
            for (int i = 0; i < nChildren; ++i) {
                if (fNode.getChild(i) instanceof XTableFunction) {
                    DataType dataType = (DataType)((XTableFunction)fNode.getChild(i)).getDataType();
                    if (dataType.isRowType()) {
                        rowType = (RowType)dataType;
                        for (int j = 0; j < rowType.getNumberColumns(); ++j) {
                            argumentTypes.push(rowType.getFieldDataType(j));
                        }
                        continue;
                    }
                    argumentTypes.push(((XExpression)fNode.getChild(i)).getDataType());
                    continue;
                }
                argumentTypes.push(((XExpression)fNode.getChild(i)).getDataType());
            }
            ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
            messageContext.add(node);
            function = FunctionManager.getFunction(fNode.getFunctionName(), argumentTypes.toArray(new IDataType[argumentTypes.size()]), fNode.isUdf());
            if (null == function) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFunction, fNode.getFunctionName(), messageContext);
                throw new XQEOlapUnsupportedQueryException(message);
            }
        }
        XVectorContext vContext = null;
        XTableFunction xNode = (XTableFunction)nodeFactory.createXNode(501015);
        xNode.setFunction(function);
        xNode.setDatasource(fNode.getDataSource());
        xNode.setDataType(fNode.getDataType());
        xNode.setIsNested(fNode.isNested());
        if (fNode.hasOnErrorPolicyBeenSet()) {
            xNode.setOnErrorPolicy(fNode.getOnErrorPolicy());
        }
        if ((subTree = (XNode)fNode.getPropertyValue("cursorExecutionPlan")) != null) {
            xNode.setSubTree(subTree);
            vContext = subTree.getVectorizationContext();
        }
        if ((valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043)) != null && valueDecorationNode.isVectorized()) {
            if (fNode.isNested() && fNode.getSubType() == SQLTableFunction.SubType.JSON_TABLE) {
                xNode.setVectorizationContext(null);
            } else if (vContext == null) {
                rowType = (RowType)fNode.getDataType();
                xNode.setVectorizationContext(new XVectorContext(rowType.getNumberColumns()));
            } else {
                xNode.setVectorizationContext(vContext);
            }
        }
        fNode.exchange(xNode, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }
}

