/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.ISetFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.XValueComparator;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XWindowFunction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class GenerateXWindowFunction
extends RQETransformation {
    public static final String PROPERTY_DISTINCT = "distinct";

    public GenerateXWindowFunction() {
        this.mName = "Generate XSetWindowFunction node.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate fNode = (SQLAggregate)node;
        SQLWindow window = (SQLWindow)fNode.getFirstChildByType(301041);
        if (window.getOrderBy() != null && fNode.isDistinct()) {
            fNode.removeProperty(PROPERTY_DISTINCT);
            Object ee = environment.getExecutionEnvironment();
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_UnsupportedDistinct, XQEMessages.getCurrProductLocale(), fNode.getFunctionName());
            ee.addNag(nagMsg);
        }
        int nChildren = fNode.getNumberChildren() - 1;
        IDataType[] argumentTypes = new IDataType[nChildren];
        for (int i = 0; i < argumentTypes.length; ++i) {
            argumentTypes[i] = ((XExpression)node.getChild(i)).getDataType();
        }
        ISetFunction function = (ISetFunction)FunctionManager.getFunction(fNode.getFunctionName(), argumentTypes, fNode.isUdf());
        if (function == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_LocalProcessingAggregate, fNode.getFunctionName());
        }
        function.setDistinct(fNode.isDistinct());
        XValueComparator xComparator = (XValueComparator)fNode.getFirstDescendantOfTypeOrdered(501083, false);
        if (xComparator != null) {
            function.setComparator(xComparator.getComparator());
        }
        XWindowFunction xNode = (XWindowFunction)nodeFactory.createXNode(501094);
        xNode.setFunction(function);
        xNode.setDataType(function.getResultDataType(argumentTypes));
        node.exchange(xNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = ((SQLAggregate)node).isWindowedAggregate();
        if (status) {
            this.traceQueryCondition(status, " SQLWindow node exists", trace);
        } else {
            this.traceQueryCondition(status, " SQLWindow node doesn't exist", trace);
        }
        return status;
    }
}

