/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPHashJoin;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorHashJoin;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;

public final class GenerateXVectorHashJoin
extends RQEVectorTransformation {
    public GenerateXVectorHashJoin() {
        this.mName = "Generate XVectorHashJoin node.";
        this.mTypes = new int[]{901015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        QEPHashJoin plan = (QEPHashJoin)node;
        XVectorHashJoin xJoin = (XVectorHashJoin)nodeFactory.createXNode(501183);
        xJoin.setJoinType(plan.getJoinType());
        xJoin.setJoins(plan.getJoins());
        xJoin.setNoDuplicatesInBuildTable(plan.getNoDuplicatesInBuildTable());
        xJoin.setVectorizationContext(new XVectorContext(plan.getNumberColumns()));
        node.exchange(xJoin, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XJoin.JoinType joinType = ((QEPJoin)node).getJoinType();
        boolean bl = status = joinType != XJoin.JoinType.ANTI && joinType != XJoin.JoinType.SEMI;
        if (status) {
            this.traceQueryCondition(status, "Join plan is not a hash anti-join or hash semi-join plan.", trace);
        } else {
            this.traceQueryCondition(status, "Join plan is a hash anti-join or hash semi-join plan.", trace);
        }
        return status;
    }
}

