/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorLiteral;
import com.cognos.xqe.runtree.relational.vectorization.XVectorLiteralNull;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;

public final class GenerateXVectorLiteral
extends RQEVectorTransformation {
    public GenerateXVectorLiteral() {
        this.mName = "Generate XVectorLiteral node.";
        this.mTypes = new int[]{301031, 301068, 301050, 301070};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IVectorContext dfNode = (IVectorContext)((Object)node.getAncestorOfCategory(301089));
        XVectorContext vContext = dfNode.getVectorizationContext();
        Value value = null;
        switch (node.getType()) {
            case 301031: {
                value = ((SQLLiteral)node).getValue();
                break;
            }
            case 301050: 
            case 301070: {
                value = DataValueFactory.createNullValue();
                break;
            }
            case 301067: {
                String name = ((SQLIdentifier)node).getName();
                value = DataValueFactory.createCharValue(name.length());
                value.set(name);
                break;
            }
            case 301068: {
                String option = ((SQLOption)node).getValue();
                value = DataValueFactory.createCharValue(option.length());
                value.set(option);
                break;
            }
        }
        IDataType dType = value.getDataType();
        int outputColumnNo = vContext.allocateOutputColumn(dType);
        if (value.isNull()) {
            XVectorLiteralNull xNode = (XVectorLiteralNull)factory.createXNode(501176);
            xNode.setDataType(dType);
            xNode.setOutputColumnNo(outputColumnNo);
            node.exchange(xNode);
        } else {
            XVectorLiteral xNode = (XVectorLiteral)factory.createXNode(501175);
            xNode.setDataType(dType);
            xNode.setValue(outputColumnNo, dType, value);
            node.exchange(xNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        IXQEQueryNode grandParent = parent.getParent();
        boolean bl = status = node.getType() == 301031 && parent.getType() != 301045 && ((SQLLiteral)node).getDataType().isBoolean() || parent.getType() == 301030 && (grandParent.isOfCategory(301015) || grandParent.getType() == 301072) || parent.getType() == 301040 && grandParent.getType() == 301076 || parent.getType() == 301034 || parent.getType() == 301033 && ((SQLFunction)parent).isDurationFunction() || parent.getType() == 301026 && ((SQLComparison)parent).isAlwaysFalse();
        if (status) {
            this.traceQueryCondition(status, "Field identifier node is a projected column.", trace);
        } else {
            this.traceQueryCondition(status, "Field identifier node is not a projected column.", trace);
        }
        return status;
    }
}

