/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSearch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSort;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;

public class GenerateXVectorSearch
extends RQEVectorTransformation {
    public GenerateXVectorSearch() {
        this.mName = "Generate XVectorSearchNode node.";
        this.mTypes = new int[]{301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean notIn = false;
        boolean filter = true;
        if (node.getParent().getType() == 301027 && ((SQLLogical)node.getParent()).getSubType() == SQLLogical.SubType.NOT) {
            notIn = true;
            node.getParent().extract();
        }
        if (!ASTUtil.isInFilterContext(node)) {
            filter = false;
        }
        IVectorContext dfNode = (IVectorContext)((Object)node.getAncestorOfCategory(301089));
        XVectorContext vContext = dfNode.getVectorizationContext();
        XVectorSearch xSearch = (XVectorSearch)factory.createXNode(501194);
        if (!filter) {
            int outputCol = vContext.allocateOutputColumn(DataTypeFactory.getLongType());
            xSearch.setOutColumnNumber(outputCol);
        }
        XVectorSort xSort = (XVectorSort)factory.createXNode(501179);
        xSort.setDistinct(true);
        int numberOfCols = 1;
        RowType dType = (RowType)((SQLSubQuery)node.getChild(1)).getDataType();
        numberOfCols = dType.getNumberColumns();
        OrderBy[] orderByList = new OrderBy[numberOfCols];
        for (int i = 0; i < numberOfCols; ++i) {
            orderByList[i] = new OrderBy(i, true, SQLSortKey.NullOrdering.NULLS_LAST);
        }
        xSort.setSortKeyList(orderByList);
        node.getChild(1).exchange(xSort, true);
        if (xSort.getChild(0).getType() == 501190 || xSort.getChild(0).getType() == 301008) {
            xSort.getChild(0).extract();
        }
        xSort.setVectorizationContext(((IVectorContext)((Object)xSort.getChild(0))).getVectorizationContext());
        xSort.detach();
        xSearch.addChild(xSort);
        IXQEQueryNode expr = node.getChild(0);
        expr.detach();
        int[] columnIndices = null;
        if (expr.getType() == 301040 || expr.getType() == 501051) {
            columnIndices = new int[expr.getNumberChildren()];
            IXQEQueryNode[] children = expr.getChildren();
            expr.detachChildren();
            for (int i = 0; i < children.length; ++i) {
                IXQEQueryNode child = children[i];
                if (child.getType() == 301032) {
                    columnIndices[i] = ((SQLFid)child).getVirtualColumnNo();
                } else if (child instanceof XVectorExpression) {
                    xSearch.addChild(child);
                    columnIndices[i] = ((XVectorExpression)child).getColumnNo();
                }
                if (XVectorRowBatchUtil.getVectorTypeFromDataType(((IValueExpression)child).getDataType()) == XVectorRowBatchUtil.getVectorTypeFromDataType(dType.getFieldDataType(i))) continue;
                columnIndices[i] = XVectorContext.generateCast(environment, vContext, child, dType.getFieldDataType(i));
            }
        }
        xSearch.setColumnNumbers(columnIndices);
        xSearch.setNotIn(notIn);
        node.exchange(xSearch, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getChild(1).getType() == 301059;
        if (status) {
            this.traceQueryCondition(status, "Comparison node is an IN predicate.", trace);
        } else {
            this.traceQueryCondition(status, "Comparison node is not an IN predicate.", trace);
        }
        return status;
    }
}

