/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.VectorOp;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;

public final class GenerateXVectorSetFunction
extends RQEVectorTransformation {
    public GenerateXVectorSetFunction() {
        this.mName = "Generate XVectorSetFunction node.";
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode parent;
        SQLAggregate fNode = (SQLAggregate)node;
        IVectorContext dfNode = (IVectorContext)((Object)node.getAncestorOfCategory(301089));
        IDataType returnType = fNode.getDataType();
        XVectorContext vContext = dfNode.getVectorizationContext();
        Class<?> vClass = fNode.getVectorClass(returnType);
        int nChildren = fNode.getNumberChildren();
        Object[] arguments = new Object[nChildren];
        IXQEQueryNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode child = children[i];
            if (child.getType() == 301050) {
                child.detach();
                arguments[i] = null;
                continue;
            }
            if (child.getType() == 301068) {
                arguments[i] = ((SQLOption)child.detach()).getValue();
                continue;
            }
            if (child.getType() == 301031) {
                arguments[i] = XVectorContext.getObjectForLiteral((SQLLiteral)child.detach());
                continue;
            }
            if (child.getType() == 301032) {
                arguments[i] = ((SQLFid)child.detach()).getVirtualColumnNo();
                continue;
            }
            if (child.getType() == 301030) {
                int[] valuesInList = new int[child.getNumberChildren()];
                for (int j = 0; j < child.getNumberChildren(); ++j) {
                    valuesInList[j] = ((SQLFid)child.getChild(j)).getVirtualColumnNo();
                }
                child.detach();
                arguments[i] = valuesInList;
                continue;
            }
            arguments[i] = ((XVectorExpression)child).getColumnNo();
        }
        XVectorExpression vExpr = XVectorContext.createVectorExpression(environment, vContext, vClass, VectorOp.AGGREGATE, returnType, arguments);
        if ((node.getType() == 301024 || node.getType() == 301045) && (parent = node.getParent()).getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT) {
            parent.extract();
        }
        node.exchange(vExpr, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] windows = node.getChildrenOfType(301041);
        boolean bl = status = windows.length == 0;
        if (status) {
            this.traceQueryCondition(status, " The function is a standard aggregate", trace);
        } else {
            this.traceQueryCondition(status, " The function is windowed aggregate", trace);
        }
        return status;
    }
}

