/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XDimensionalStore;
import com.cognos.xqe.runtree.olap.XDimensionalStoreReference;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class ReplaceInWindowMasterQueryByCombinedQuery
extends Transformation {
    static final String PROPERTY_MASTER_QUERY_IS_COMBINED_QUERY = "masterQueryIsCombinedQuery";

    public ReplaceInWindowMasterQueryByCombinedQuery() {
        this.mName = "Replace in window and master query by combined query.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{601026};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MasterDetailWindow mdwMaster = (V5MasterDetailWindow)node;
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        V5MasterDetailWindow detailWindow = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwMaster.getMasterDetailWindowNodeIDDetail());
        List<IXQEQueryNode> queriesMaster = mdwMaster.getDescendantsOfCategory(501017, false);
        List<IXQEQueryNode> queriesDetail = detailWindow.getChild(0).getDescendantsOfCategory(501130, false);
        if (queriesDetail.size() != 1) {
            queriesDetail = detailWindow.getDescendantsOfCategory(501017, false);
        } else {
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            XDimensionalStoreReference xDimStoreRef = (XDimensionalStoreReference)nodeFactory.createXNode(501158);
            xDimStoreRef.setReferencedDimStore((XDimensionalStore)queriesDetail.get(0));
            queriesDetail.clear();
            queriesDetail.add(xDimStoreRef);
        }
        if (queriesDetail.size() != 1) {
            node.throwInternalError("V5MasterDetailWindow node for the detail query does not have the expected XDimensionalStoredescendant");
        }
        IXQEQueryNode parent = queriesMaster.get(0).getParent();
        queriesMaster.get(0).detach();
        IXQEQueryNode detailQuery = queriesDetail.get(0);
        IXQEQueryNode reform = detailQuery.getAncestorOfType(501096);
        mdwMaster.extract();
        parent.addChild(mdwMaster, 0);
        mdwMaster.addChild(detailQuery);
        if (reform != null) {
            reform = environment.getNodeFactory().copyNode(reform);
            detailQuery.insertParent(reform);
        }
        mdwMaster.setPropertyValue(PROPERTY_MASTER_QUERY_IS_COMBINED_QUERY, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getAncestorOfType(601026) == null;
        if (status) {
            this.traceQueryCondition(status, "Node is the top most master window on the stack.", trace);
        } else {
            this.traceQueryCondition(status, "Node is not the top most master window on the stack.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getPropertyValue(PROPERTY_MASTER_QUERY_IS_COMBINED_QUERY) != null;
        if (status) {
            this.traceNodeCondition(false, "Transformation already applied.", trace);
            return false;
        }
        V5MasterDetailWindow mdw = (V5MasterDetailWindow)node;
        boolean bl2 = status = mdw.getMasterDetailWindowNodeIDMaster() == mdw.getId().intValue();
        if (!status) {
            this.traceNodeCondition(status, "Node is not the window on the master query.", trace);
            return false;
        }
        this.traceNodeCondition(status, "Node is the window on the maser query.", trace);
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        V5MasterDetailWindow detailWindow = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdw.getMasterDetailWindowNodeIDDetail());
        Object prop = detailWindow.getPropertyValue(PROPERTY_MASTER_QUERY_IS_COMBINED_QUERY);
        boolean bl3 = status = prop != null && (Boolean)prop != false;
        if (!status) {
            this.traceNodeCondition(status, "Combined query has not been copied in detail window.", trace);
            return false;
        }
        this.traceNodeCondition(status, "Combined query has been copied in detail window.", trace);
        return status;
    }
}

