/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class AdjustModFilterLiteralType
extends Transformation {
    public AdjustModFilterLiteralType() {
        this.mName = "Adjust the V5Literal Value according to the datatype of the data item being filtered.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] filterConditions;
        for (IXQEQueryNode condition : filterConditions = node.getDescendantsOfTypes(new int[]{201011, 201013, 201008}, false)) {
            IXQEQueryNode[] literals;
            IXQEQueryNode left = condition.getChild(0);
            IDataType type = null;
            String leftOperandName = null;
            if (left.getType() == 101003) {
                type = ((V5DataItem)left).getDataType();
                leftOperandName = ((V5DataItem)left).getFullName();
            } else if (left.getType() == 201116) {
                type = ((V5BoundModelIdentifier)left).getDataType();
                leftOperandName = ((V5BoundModelIdentifier)left).getExpression();
            }
            if (type != null && !type.isNumeric() && !type.isDatetime()) continue;
            for (IXQEQueryNode child : literals = condition.getChildrenOfType(201026)) {
                V5LiteralValue literal = (V5LiteralValue)child;
                IXQEQueryNode enode = null;
                boolean validLiteral = true;
                try {
                    enode = V5ExpressionProcessor.process(literal.getValue().getString(), environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
                }
                catch (XQERuntimeException xre) {
                    validLiteral = false;
                }
                if (!validLiteral || enode == null || enode.getType() != 201026 || ((V5LiteralValue)enode).getDataType() == null) {
                    String errorMessage = "Invalid filter condition. The type of the filtered data item '" + leftOperandName + " can not be determined or filter value type '" + literal.getValue().getString() + "' is incorrect.";
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, errorMessage);
                }
                IDataType literalDataType = ((V5LiteralValue)enode).getDataType();
                if (type != null && (!type.isNumeric() || !literalDataType.isNumeric()) && !type.equals(literalDataType)) continue;
                child.exchange(enode);
            }
        }
        node.removeProperty("convertedFromModFilter");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] filterConditions;
        XQETrace trace = environment.getTrace();
        V5DetailFilter v5DetailFilter = (V5DetailFilter)node;
        if (!v5DetailFilter.getBooleanPropertyValue("convertedFromModFilter", Boolean.FALSE).booleanValue()) {
            this.traceNodeCondition(false, "This V5DetailFilter node was not converted from a ModFilter.", trace);
            return false;
        }
        for (IXQEQueryNode condition : filterConditions = node.getDescendantsOfTypes(new int[]{201011, 201013, 201008}, false)) {
            IXQEQueryNode left = condition.getChild(0);
            IDataType type = null;
            if (left.getType() == 101003) {
                type = ((V5DataItem)left).getDataType();
            } else if (left.getType() == 201116) {
                type = ((V5BoundModelIdentifier)left).getDataType();
            }
            if (type != null) {
                V5LiteralValue literal;
                IXQEQueryNode[] literals;
                if (type.isNumeric()) {
                    for (IXQEQueryNode child : literals = condition.getChildrenOfType(201026)) {
                        literal = (V5LiteralValue)child;
                        if (literal.getDataType().isNumeric()) continue;
                        this.traceNodeCondition(true, "This V5DetailFilter is Filtering a numeric column.", trace);
                        return true;
                    }
                    continue;
                }
                if (!type.isDatetime()) continue;
                for (IXQEQueryNode child : literals = condition.getChildrenOfType(201026)) {
                    literal = (V5LiteralValue)child;
                    if (literal.getDataType().isDatetime()) continue;
                    this.traceNodeCondition(true, "This V5DetailFilter is Filtering a datetime column.", trace);
                    return true;
                }
                continue;
            }
            this.traceNodeCondition(true, "Column has data type null, need to adjust literal values.", trace);
            return true;
        }
        this.traceNodeCondition(false, "This filter does not need to adjust literal types.", trace);
        return false;
    }
}

