/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.util.V5ParameterUtil;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.BindV5ParameterUtil;
import com.cognos.xqemoser.MoserParameterUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class BindV5Parameter
extends Transformation {
    public BindV5Parameter(int[] passNumbers) {
        this.mName = "Bind V5Parameter to the model.";
        this.mPassNumbers = passNumbers;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[1];
        this.mTypes[0] = 201024;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BindV5Parameter.bindV5ParameterToBoundParameter(node, environment);
    }

    protected static void setModelPathIfRequired(V5Parameter v5Parameter, Parameter parameter, PlanningEnvironment environment) {
        if (environment.isMultimodelCase()) {
            String path = null;
            V5Query query = v5Parameter.getV5Query();
            if (query != null) {
                String type;
                V5QuerySet querySet;
                path = query.getMetadataPathInSource();
                if (path == null) {
                    path = query.getMetadataPath();
                }
                IXQEQueryNode child = null;
                if (query.getV5Source() != null) {
                    child = query.getV5Source().getFirstChildByType(101016);
                }
                if (path == null && child == null && (querySet = (V5QuerySet)v5Parameter.getAncestorOfType(101002)) != null && !"module".equals(type = querySet.getModelType())) {
                    path = environment.getModelPath();
                }
            } else {
                path = environment.getModelPath();
            }
            if (path != null) {
                v5Parameter.setModelPath(path);
                parameter.setModelPath(path);
            }
        } else {
            String type;
            String path;
            V5QuerySet querySet = (V5QuerySet)v5Parameter.getAncestorOfType(101002);
            if (querySet != null && querySet.getPropertyValue("orgModelPath") != null && (path = querySet.getModelPath()) != null && "module".equals(type = querySet.getModelType())) {
                v5Parameter.setModulePath(path);
                parameter.setModulePath(path);
            }
        }
    }

    public static void bindV5ParameterToBoundParameter(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean bNewParam;
        Parameter parameter;
        String parameterName;
        XQENodeFactory nodeFactory;
        V5Parameter v5Parameter;
        block17: {
            v5Parameter = (V5Parameter)node;
            BindV5ParameterUtil.setDataType(node, environment);
            V5ParameterUtil.setV5ParameterProperties(v5Parameter);
            nodeFactory = environment.getNodeFactory();
            Parameters parameters = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters();
            parameterName = parameters.getParameterName(v5Parameter.getParameterName(), v5Parameter.getQueryName(), v5Parameter.isMasterDetail(), environment).trim();
            parameter = parameters.getParameter(parameterName);
            bNewParam = false;
            if (null == parameter) {
                parameter = new Parameter(parameterName, v5Parameter.getQueryName());
                if (!v5Parameter.getParameterName().equals(parameterName)) {
                    parameter.setOriginalName(v5Parameter.getParameterName().trim());
                }
                parameters.addParameter(parameterName, parameter);
                parameter.setIsOnlyReferencedInQuery(true);
                bNewParam = true;
            }
            if (v5Parameter.isMasterDetail().booleanValue()) {
                MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
                List<V5DataItem> dis = mdProvider.getV5DataItemInMasterQuery(v5Parameter, v5Parameter.getQueryName());
                for (V5DataItem di : dis) {
                    di.setPropertyValue("linkParameter", parameter);
                }
            }
            parameter.incrementQueryReferenceCount();
            if (parameter.getModulePath() == null && v5Parameter.getModulePath() != null) {
                String metadataPath = v5Parameter.getModulePath();
                parameter.setModulePath(metadataPath);
            } else {
                BindV5Parameter.setModelPathIfRequired(v5Parameter, parameter, environment);
            }
            parameter.setOrderIndex(v5Parameter.getOrderIndex());
            try {
                BindV5ParameterUtil.setParameterProperties(v5Parameter, parameter, environment);
            }
            catch (XQERuntimeException e) {
                if (XQEMessageKeys.PLN_PromptWithConflictingDataTypes != e.getMessageKey() && XQEMessageKeys.PLN_InvalidPromptDataType != e.getMessageKey() && XQEMessageKeys.PLN_PromptMultiModels != e.getMessageKey()) break block17;
                parameters.clear();
                throw e;
            }
        }
        boolean isDMR = v5Parameter.getV5Query().isDMR();
        V5BoundParameter newNode = (V5BoundParameter)nodeFactory.createNode(201127);
        newNode.setParameterName(parameterName);
        if (parameter.getModelItem() != null) {
            newNode.setIdentifier(parameter.getModelItem());
        } else {
            newNode.setValueExpression(parameter.getValueExpression());
        }
        newNode.setMetadata(v5Parameter.getMetadata());
        newNode.setIsLiteral(v5Parameter.isLiteral());
        newNode.setDataType(v5Parameter.getDataType());
        newNode.setNativeName(v5Parameter.getNativeName());
        newNode.setMultivalued(v5Parameter.isMultivalued());
        newNode.setIsMemberPrompt(v5Parameter.isMemberParameter());
        newNode.setQueryName(v5Parameter.getQueryName());
        newNode.setIsMasterDetailParameter(v5Parameter.isMasterDetail());
        node.exchange(newNode, false);
        if (!parameter.isLiteral()) {
            List<ILevel> levels = V5ParameterUtil.getLevels(newNode);
            if (levels.size() == 0) {
                parameter.setHierarchy(newNode.getHierarchy());
            } else {
                parameter.setLevels(levels);
            }
        } else if (newNode.getHierarchy() != null) {
            parameter.setProviderHierarchyUniqueName(newNode.getHierarchy().getUniqueName());
        }
        if (parameter.isMasterDetailLinkParameter()) {
            IXQEQueryNode detailFilter = newNode.getAncestorOfType(101008);
            BindV5ParameterUtil.updateDetailFilter(parameter, detailFilter, isDMR);
        }
        parameter.bind(environment);
        newNode.setDataType(parameter.getDataType());
        if (bNewParam) {
            MoserParameterUtil.cloneParameterValues(parameter, environment, false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder msg = new StringBuilder();
        if (!BindV5ParameterUtil.passBaseCondition(node, environment, msg)) {
            this.traceNodeCondition(false, msg.toString(), trace);
            return false;
        }
        this.traceNodeCondition(true, "Metadata and data type is available.", trace);
        return true;
    }
}

