/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5OrderFunction;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.util.Governors;

public class ConvertDMRMemberSortToV5OrderFunction
extends Transformation {
    public ConvertDMRMemberSortToV5OrderFunction() {
        this.mName = "Convert DMR memberSort into a V5Order function.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        LevelWrapper level = (LevelWrapper)((V5BoundModelIdentifier)node).getMetadata();
        ((V5BoundModelIdentifier)node).setPropertyValue("isDMRMemberSortApplied", "true");
        ISortItem[] memberSorts = level.getSortItems();
        IXQEQueryNode parentNode = node;
        if (parentNode.getParent().getType() == 201086) {
            parentNode = parentNode.getParent();
        } else {
            parentNode = nodeFactory.createNode(201086);
            node.insertParent(parentNode);
        }
        for (int i = 0; i < memberSorts.length; ++i) {
            ISortItem memberSort = memberSorts[i];
            V5OrderFunction orderExpr = (V5OrderFunction)nodeFactory.createNode(201091);
            parentNode.insertParent(orderExpr);
            String refObjExpr = memberSort.getRefObject();
            V5BoundModelIdentifier sortingExpr = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            IMetadata newMetadata = environment.getMetadataConnection().bindMetadataReference(refObjExpr);
            sortingExpr.setMetadata(newMetadata);
            sortingExpr.setIdentifier(newMetadata.getV5UniqueName());
            orderExpr.addChild(sortingExpr);
            int sortOption = 3;
            if (memberSort.getSort() == ISortItem.SortType.DESCENDING) {
                sortOption = 4;
            }
            orderExpr.setOption(sortOption);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IDimension wrappedDim;
        LevelWrapper level;
        IDimension dimension;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("isDMRMemberSortApplied") != null) {
            this.traceNodeCondition(false, "This identifier has already applied the DMR memberSort.", trace);
            return false;
        }
        V5Query query = DMRUtilities.findQuery(node);
        if (query == null || !query.isDMR()) {
            this.traceNodeCondition(false, "Query is not DMR.", environment.getTrace());
            return false;
        }
        IXQEQueryNode v5node = node.getAncestorOfTypes(new int[]{101010, 101008});
        if (v5node != null) {
            this.traceNodeCondition(false, "Identifier is part of a filter", environment.getTrace());
            return false;
        }
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 201086) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() != 101003) {
            this.traceNodeCondition(false, "Identifier is not just a LEVEL or members(LEVEL)", environment.getTrace());
            return false;
        }
        IMetadata metadata = ((V5BoundToMetadata)node).getMetadata();
        if (metadata == null || !metadata.isDMR()) {
            this.traceNodeCondition(false, "Identifier is not a DMR expression.", trace);
            return false;
        }
        if (metadata instanceof LevelWrapper && (dimension = (level = (LevelWrapper)metadata).getDimension()) instanceof AbstractDimensionWrapper && (wrappedDim = ((AbstractDimensionWrapper)dimension).getWrappedDimension()) instanceof IDimension && wrappedDim.getSortMembersData() && !wrappedDim.getSortMembersAndEnableMrf() && !query.getGovernors().getAutoSort().equals((Object)Governors.AutoSort.NONE) && level.getSortItems().length > 0) {
            this.traceNodeCondition(true, "DMR memberSort will be converted into a V5Order function.", trace);
            return true;
        }
        this.traceNodeCondition(false, "DMR memberSort will not be converted into a V5Order function.", trace);
        return false;
    }
}

