/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ShowAll;
import com.cognos.xqe.ast.localprocessing.v5.V5ShowAllRule;
import com.cognos.xqe.ast.localprocessing.v5.V5Suppress;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.util.V5QueryTypeCheck;
import java.util.ArrayList;

public class ConvertShowallAttributeToV5ShowAll
extends Transformation {
    public ConvertShowallAttributeToV5ShowAll() {
        this.mName = "Create the local processing node V5ShowAll.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5DataItem v5DataItem = (V5DataItem)node;
        if (v5DataItem.getContextProperty() != null) {
            v5DataItem.setShowAllProperty(false);
            int aSeverity = 1;
            ResponseMessage.ResponseMessageType aType = ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_ContextAndShowallAttributeCannotCoexist, v5DataItem.getNameProperty()));
            return;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        IXQEQueryNode[] rsapiDatasets = v5QuerySet.getChildrenOfType(401005);
        RSAPIDataset rsapiDataset = (RSAPIDataset)rsapiDatasets[0];
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)rsapiDataset.getFirstDescendantOfTypeOrdered(101055, false);
        this.checkSortedDataItemsForRelational(v5QuerySet, v5QRD);
        IXQEQueryNode topNode = rsapiDataset.getChild(0);
        V5Suppress v5Suppress = null;
        if (topNode.getType() == 601022) {
            v5Suppress = (V5Suppress)topNode;
        } else {
            IXQEQueryNode[] v5SuppressNodes = rsapiDataset.getDescendantsOfType(601022, false);
            if (null != v5SuppressNodes && v5SuppressNodes.length > 0) {
                v5Suppress = (V5Suppress)v5SuppressNodes[0];
            }
        }
        V5ShowAll v5ShowAll = (V5ShowAll)nodeFactory.createNode(601028);
        if (v5Suppress == null) {
            if (v5QRD != null && V5QueryTypeCheck.isRelationalQuery(v5QRD)) {
                rsapiDataset.addChild(v5ShowAll);
            } else {
                topNode.insertParent(v5ShowAll);
            }
        } else {
            v5Suppress.insertParent(v5ShowAll);
        }
        V5ShowAllRule v5ShowAllRule = (V5ShowAllRule)nodeFactory.createNode(601029);
        v5ShowAllRule.setDataItemName(v5DataItem.getNameProperty());
        IXQEQueryNode[] v5Edges = v5QRD.getChildrenOfType(101049);
        V5Edge v5Edge = (V5Edge)v5Edges[0];
        v5ShowAllRule.setEdgeOrdinal(v5Edge.getEdgeID());
        v5ShowAll.addChild(v5ShowAllRule);
        v5ShowAll.setSubQuerySet(v5DataItem.getShowAllSubQuerySet());
        v5DataItem.setShowAllProperty(false);
    }

    private void checkSortedDataItemsForRelational(V5QuerySet v5QuerySet, V5QueryResultDefinition v5QRD) {
        IXQEQueryNode[] valueSetChildren;
        boolean isRelational = V5QueryTypeCheck.isRelationalQuery(v5QRD);
        if (!isRelational) {
            return;
        }
        ArrayList<V5DataItem> nonMeasureDataItems = null;
        V5Query v5Query = (V5Query)v5QuerySet.getFirstChildByType(101006);
        V5Selection v5Selection = (V5Selection)v5Query.getFirstChildByType(101009);
        IXQEQueryNode[] dataItems = v5Selection.getDescendantsOfType(101003, false);
        nonMeasureDataItems = new ArrayList<V5DataItem>(dataItems.length);
        for (IXQEQueryNode dataItem : dataItems) {
            V5DataItem currV5DataItem = (V5DataItem)dataItem;
            if (nonMeasureDataItems == null || !currV5DataItem.isGroupingItem()) continue;
            nonMeasureDataItems.add(currV5DataItem);
        }
        IXQEQueryNode[] valueSets = v5QRD.getDescendantsOfType(101057, false);
        for (IXQEQueryNode currChild : valueSetChildren = valueSets[0].getChildren()) {
            if (currChild.getType() != 101056) continue;
            V5DataItem nonMeasureSorted = null;
            String currName = ((V5SortItem)currChild).getRefDataItem();
            for (V5DataItem nonMeasureDataItem : nonMeasureDataItems) {
                if (nonMeasureDataItems.isEmpty()) break;
                if (!nonMeasureDataItem.getNameProperty().equals(currName)) continue;
                nonMeasureSorted = nonMeasureDataItem;
                break;
            }
            nonMeasureDataItems.remove(nonMeasureSorted);
        }
        if (!nonMeasureDataItems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (V5DataItem nonMeasureDataItem : nonMeasureDataItems) {
                if (sb.length() > 0) {
                    sb.append(" , ");
                }
                sb.append(nonMeasureDataItem.getNameProperty());
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedShowAllForNonSortedRelational, sb.toString());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        if (!Boolean.TRUE.equals(v5DataItem.getShowAllProperty())) {
            this.traceNodeCondition(false, "The data item has not set the showall flag.", trace);
            return false;
        }
        if (v5DataItem.getShowAllSubQuerySet() == null) {
            this.traceNodeCondition(false, "The data item has not a showall V5QuerySet.", trace);
            return false;
        }
        if (v5DataItem.getParent() == null || v5DataItem.getParent().getType() != 101009) {
            this.traceNodeCondition(false, "The data item is not under a V5Selection node.", trace);
            return false;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (v5QuerySet == null) {
            this.traceNodeCondition(false, "No V5QuerySet node is found.", trace);
            return false;
        }
        IXQEQueryNode[] rsapiDatasets = v5QuerySet.getChildrenOfType(401005);
        if (null == rsapiDatasets || rsapiDatasets.length == 0) {
            this.traceNodeCondition(false, "No rsapiDataset node is found.", trace);
            return false;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)rsapiDatasets[0];
        String reason = "Is not a list report.";
        if (!rsapiDataset.isListReport()) {
            this.traceNodeCondition(false, "Is not a list report.", trace);
            return false;
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)rsapiDataset.getFirstDescendantOfTypeOrdered(101055, false);
        V5ShowAll v5ShowAll = (V5ShowAll)rsapiDataset.getFirstDescendantOfTypeOrdered(601028, false);
        if (null != v5ShowAll) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedShowAllOnMultipleDataItems, qrd.getRefQueryProperty());
        }
        if (qrd.getDescendantsOfType(101050, false).length > 1) {
            this.traceNodeCondition(false, "Is not a list report.", trace);
            return false;
        }
        IXQEQueryNode[] v5EdgeSuppressions = rsapiDataset.getDescendantsOfType(101066, false);
        if (null != v5EdgeSuppressions && v5EdgeSuppressions.length > 0 && null != v5EdgeSuppressions[0]) {
            this.traceNodeCondition(false, "Must create first the V5Suppress node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Can create the V5ShowAll node.", trace);
        return true;
    }
}

