/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ConvertV5BetweenToANDCondition
extends Transformation {
    public ConvertV5BetweenToANDCondition(int[] passNumbers) {
        this.mName = "Converts V5BetweenExpression to AND Condition.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ConvertV5BetweenToANDCondition.convertV5BetweenToANDCondition(nodeFactory, node);
    }

    public static void convertV5BetweenToANDCondition(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        V5LogicalExpression andExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
        andExpr.setSubType(0);
        if (node.getPropertyValue("parsedJoinExpression") != null) {
            andExpr.setPropertyValue("parsedJoinExpression", node.getPropertyValue("parsedJoinExpression"));
        }
        IXQEQueryNode valueExpr = node.getChild(0);
        IXQEQueryNode lowerBound = node.getChild(1);
        IXQEQueryNode upperBound = node.getChild(2);
        V5ComparisonExpression geqExpr = (V5ComparisonExpression)nodeFactory.createNode(201013);
        geqExpr.setSubType(4);
        valueExpr.move(geqExpr);
        lowerBound.move(geqExpr);
        andExpr.addChild(geqExpr);
        V5ComparisonExpression leqExpr = (V5ComparisonExpression)nodeFactory.createNode(201013);
        leqExpr.setSubType(1);
        leqExpr.addChild(nodeFactory.deepCopyNode(valueExpr));
        upperBound.move(leqExpr);
        andExpr.addChild(leqExpr);
        node.getParent().exchangeChildNode(node, andExpr, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 3) {
            this.traceNodeCondition(false, "The V5BetweenExpression does not have the required number of operands.", trace);
            return false;
        }
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query.isRelStyle()) {
            return false;
        }
        boolean isValueExpression = true;
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode valueExpr = node.getChild(i);
            if (V5ExpressionCheck.isValueExpression(valueExpr) || V5ExpressionCheck.canBeCoercedToValueExpression(valueExpr)) continue;
            isValueExpression = false;
            break;
        }
        if (!isValueExpression) {
            this.traceNodeCondition(false, "The parameter for V5BetweenExpression is invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5BetweenExpression is valid.", trace);
        return true;
    }
}

