/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class CopySolveOrderFromQRDToDataItem
extends Transformation {
    public CopySolveOrderFromQRDToDataItem() {
        this.mName = "Copy the solveOrder from the QRD to the dataItem (where it is expected to be).";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSet valueSet = (V5ValueSet)node;
        Integer solveOrder = (Integer)valueSet.getPropertyValue("solveOrder");
        V5DataItem dataItem = this.getReferencedDataItem(valueSet);
        dataItem.setSolveOrderProperty(solveOrder);
        int aSeverity = 1;
        environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.DLT_DeprecatedSolveOrderInQRD, dataItem.getNameProperty()));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5ValueSet valueSet = (V5ValueSet)node;
        if (valueSet.getPropertyValue("solveOrder") == null) {
            this.traceNodeCondition(false, "The value set does not have a solveOrder property.", trace);
            return false;
        }
        V5DataItem referencedDataItem = this.getReferencedDataItem(valueSet);
        if (referencedDataItem == null) {
            this.traceNodeCondition(false, "Referenced dataItem not found.", trace);
            return false;
        }
        if (referencedDataItem.getSolveOrderProperty() != null) {
            this.traceNodeCondition(false, "The referenced data item already has a solveOrder property.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The value set has a solveOrder property that can be copied.", trace);
        return true;
    }

    private V5DataItem getReferencedDataItem(V5ValueSet valueSet) {
        IXQEQueryNode dataItemNode;
        IXQEQueryNode querySet = valueSet.getAncestorOfType(101002);
        IXQEQueryNode[] dataItemNodes = querySet.getDescendantsOfType(101003, false);
        V5DataItem dataItem = null;
        IXQEQueryNode[] iXQEQueryNodeArray = dataItemNodes;
        int n = iXQEQueryNodeArray.length;
        for (int i = 0; i < n && !(dataItem = (V5DataItem)(dataItemNode = iXQEQueryNodeArray[i])).getNameProperty().equals(valueSet.getRefDataItemProperty()); ++i) {
            dataItem = null;
        }
        return dataItem;
    }
}

