/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXSlicer;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1QueryStrategy;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class DisableLocalProcessingForSimpleQuery
extends Transformation {
    private static final String THE_TRANSFORMATION_IS_NOT_APPLICABLE = "The transformation is not applicable.";

    public DisableLocalProcessingForSimpleQuery() {
        this.mName = "Remove V5 Query Set";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 1002;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setforceLocalQueryProcessing(Boolean.FALSE);
        int aSeverity = 1;
        ResponseMessage.ResponseMessageType aType = ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT;
        environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_DisableLocalProcessingForQuery, mdxQuery.getV5NameProperty()));
        List<IXQEQueryNode> definitions = mdxQuery.getDescendantsOfCategory(1005, false);
        StringBuilder affectedCalculations = null;
        for (IXQEQueryNode definition : definitions) {
            IXQEQueryNode expression = definition.getChild(0);
            if (expression.getType() != 1084) continue;
            String caclName = ((MDXCalculatedMemberDefinition)definition).getV5Name();
            if (caclName == null || caclName.isEmpty()) {
                caclName = ((MDXCalculatedMemberDefinition)definition).getV5Caption();
            }
            if (caclName == null || caclName.isEmpty()) {
                caclName = ((MDXCalculatedMemberDefinition)definition).getUniqueName();
            }
            if (caclName == null || caclName.isEmpty()) continue;
            if (affectedCalculations == null) {
                affectedCalculations = new StringBuilder();
            } else {
                affectedCalculations.append(", ");
            }
            affectedCalculations.append(caclName);
        }
        if (affectedCalculations != null) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_NullBehaviorOfCalculationAffectedByDatasourceProcessing, mdxQuery.getV5NameProperty(), affectedCalculations.toString()));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] groups;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        String dataSourceType = mdxQuery.getDataSourceType();
        boolean status = DataSourceTypeEnum.isTM1(dataSourceType) && mdxQuery.getUseLocalQueryProcessing();
        MultiRequestContext.RequestProcessing queryHintQueryProcessing = mdxQuery.getQueryProcessingProperty();
        status = status && queryHintQueryProcessing.equals((Object)MultiRequestContext.RequestProcessing.LIMITEDLOCAL);
        int aSeverity = 1;
        ResponseMessage.ResponseMessageType aType = ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT;
        if (!status) {
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        if (LOLAPTM1QueryStrategy.useNativeTM1Engine(mdxQuery.getDataSourceType()).booleanValue()) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForUseNativeTM1Engine, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return false;
        }
        boolean bl = status = null == mdxQuery.getFirstChildByType(1010);
        if (!status) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByDetailFilter, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        boolean bl2 = status = null == mdxQuery.getFirstChildByType(1011);
        if (!status) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedBySummaryFilter, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        CogMDXSlicer slicer = (CogMDXSlicer)mdxQuery.getFirstChildByType(1009);
        boolean bl3 = status = slicer == null || slicer.getDescendantsOfType(1013, false).length == 0;
        if (!status) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByCalcInSlicer, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        boolean bl4 = status = mdxQuery.getDescendantsOfType(1003, false).length == 0;
        if (!status) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByNamedSetDefinition, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        boolean bl5 = status = mdxQuery.getDescendantsOfType(1080, false).length == 0;
        if (!status) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByReportSummary, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        for (IXQEQueryNode group : groups = mdxQuery.getDescendantsOfType(1027, false)) {
            if (group.getNumberChildren() == 1) continue;
            MDXHierInfo groupHierInfo = ((AbstractMDXSet)group.getChild(0)).getHierarchyInfo();
            MDXHierInfo nestedHierInfo = ((AbstractMDXSet)group.getChild(1)).getHierarchyInfo();
            boolean bl6 = status = !nestedHierInfo.projectsHierarchy(groupHierInfo.getProjectedHierarchy(0));
            if (status) continue;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByNestedLevels, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        List<IXQEQueryNode> setOperators = mdxQuery.getDescendantsOfCategory(1056, false);
        for (IXQEQueryNode setOperator : setOperators) {
            int[] allowedTypes;
            status = setOperator.isOfCategories(allowedTypes = new int[]{1039, 1048, 1052, 1030, 1057, 1037, 1045, 1044, 1032, 1040});
            if (status) continue;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByInvalidSet, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        List<IXQEQueryNode> definitions = mdxQuery.getDescendantsOfCategory(1005, false);
        for (IXQEQueryNode definition : definitions) {
            IXQEQueryNode expression = definition.getChild(0);
            status = this.validateCalcDefinitonExpression(expression);
            if (status) continue;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, aType, XQEMessageKeys.WRN_FailToDisableLocalProcessingForQueryCausedByInvalidCalc, mdxQuery.getV5NameProperty()));
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return status;
        }
        if (status) {
            this.traceNodeCondition(status, "The transformation is applicable.", trace);
        } else {
            this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
        }
        return status;
    }

    public boolean validateCalcDefinitonExpression(IXQEQueryNode expression) {
        if (expression.getType() != 1059 && expression.getType() != 1084) {
            return false;
        }
        if (expression.getType() == 1059 && !this.isValidValueExpression(expression)) {
            return false;
        }
        return expression.getType() != 1084 || this.isValidNumericOperator(expression);
    }

    private boolean isValidValueExpression(IXQEQueryNode expression) {
        IXQEQueryNode[] nestedCalcs;
        if (expression.getType() != 1059) {
            return false;
        }
        if (!expression.getChild(0).isOfCategory(1069)) {
            return false;
        }
        for (IXQEQueryNode nestedCalc : nestedCalcs = expression.getChild(0).getDescendantsOfType(1013, false)) {
            IXQEQueryNode nestedExpression = ((MDXCalculatedMemberReference)nestedCalc).getDefinition().getChild(0);
            if (this.validateCalcDefinitonExpression(nestedExpression)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidNumericOperator(IXQEQueryNode expression) {
        if (expression.getType() != 1084 || ((MDXNumericOperator)expression).getOperatorProperty() == 5) {
            return false;
        }
        IXQEQueryNode op1 = expression.getChild(0);
        IXQEQueryNode op2 = expression.getChild(1);
        boolean result = !(!this.isValidValueExpression(op1) && !this.isValidNumericOperator(op1) || !this.isValidValueExpression(op2) && !this.isValidNumericOperator(op2));
        return result;
    }
}

