/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveUnreferencedQRDs
extends Transformation {
    public RemoveUnreferencedQRDs(int passNumber) {
        this.mName = "Remove unreferenced QRDs";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean passesNodeCondition;
        XQETrace trace = environment.getTrace();
        V5QuerySet v5QuerySet = (V5QuerySet)node;
        boolean bl = passesNodeCondition = !v5QuerySet.getUnreferencedQRDsRemoved();
        if (passesNodeCondition) {
            this.traceQueryCondition(passesNodeCondition, "Unreferenced QRDs not yet removed.", trace);
        } else {
            this.traceQueryCondition(passesNodeCondition, "Unreferenced QRDs already removed.", trace);
        }
        return passesNodeCondition;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet v5QuerySet = (V5QuerySet)node;
        for (V5QueryResultDefinition v5QueryResultDefinition : v5QuerySet.getUnreferencedQRDs()) {
            v5QueryResultDefinition.detach();
        }
        v5QuerySet.setUnreferencedQRDsRemoved();
    }
}

