/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;
import java.util.Set;

public final class RemoveUnreferencedQueriesByQrds
extends Transformation {
    public RemoveUnreferencedQueriesByQrds(int passNumber) {
        this.mName = "Remove unreferenced Queries";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QuerySet querySet = (V5QuerySet)node;
        IXQEQueryNode[] mdLinks = querySet.getDescendantsOfType(101059, false);
        if (mdLinks.length > 0) {
            this.traceNodeCondition(false, "Master Detail Report is not considered here for now.", trace);
            return false;
        }
        if (querySet.getUnreferencedQueriesRemoved()) {
            this.traceNodeCondition(false, "Unfereneced query has been removed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "QuerySet hasn't been walked.", trace);
        return true;
    }

    public void findReferencedQuery(IXQEQueryNode node, Set<V5Query> unReferencedQueries) {
        if (unReferencedQueries.size() == 0) {
            return;
        }
        int[] types = new int[]{101025, 101027, 101004, 101013, 101014, 101054, 101018};
        HashSet<V5Query> referencedQueries = new HashSet<V5Query>();
        if (node.isOfTypes(types)) {
            if (node.getType() == 101018) {
                IXQEQueryNode[] queryRefs;
                for (IXQEQueryNode queryRef : queryRefs = node.getDescendantsOfType(101023, false)) {
                    String refName = (String)queryRef.getPropertyValue("refQuery");
                    for (V5Query query : unReferencedQueries) {
                        if (!refName.equals(query.getV5QueryName())) continue;
                        referencedQueries.add(query);
                    }
                }
            } else {
                Object exp = (String)node.getPropertyValue("expression");
                if (exp != null) {
                    if (((String)exp).contains("#sb")) {
                        MacroExpander expander = new MacroExpander();
                        exp = expander.expand(null, unReferencedQueries.iterator().next().getPlanningEnvironment(), (String)exp);
                    }
                    for (V5Query query : unReferencedQueries) {
                        if (((String)exp).indexOf(query.getV5QueryName()) <= -1) continue;
                        referencedQueries.add(query);
                    }
                } else if (node.getType() == 101004 && node.getNumberChildren() > 0) {
                    IXQEQueryNode[] multiParts;
                    for (IXQEQueryNode n : multiParts = node.getDescendantsOfType(201030, false)) {
                        V5MultiPartIdentifier multiPart = (V5MultiPartIdentifier)n;
                        String[] nameParts = multiPart.getNameParts();
                        if (nameParts.length != 2) continue;
                        for (V5Query query : unReferencedQueries) {
                            if (!nameParts[0].equals(query.getV5QueryName())) continue;
                            referencedQueries.add(query);
                        }
                    }
                }
            }
            for (V5Query query : referencedQueries) {
                if (!unReferencedQueries.contains(query)) continue;
                unReferencedQueries.remove(query);
            }
            for (V5Query query : referencedQueries) {
                this.findReferencedQuery(query, unReferencedQueries);
            }
        }
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            this.findReferencedQuery(node.getChild(i), unReferencedQueries);
        }
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node;
        IXQEQueryNode[] qrds = querySet.getDescendantsOfType(101055, true);
        HashSet<String> referencedQueryNames = new HashSet<String>();
        HashSet<V5Query> referencedQueries = new HashSet<V5Query>();
        HashSet<V5Query> unReferencedQueries = new HashSet<V5Query>();
        for (int i = 0; i < qrds.length; ++i) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)qrds[i];
            String refQueryName = qrd.getRefQueryProperty();
            referencedQueryNames.add(refQueryName);
        }
        IXQEQueryNode[] v5queries = querySet.getDescendantsOfType(101006, true);
        for (IXQEQueryNode v5Query : v5queries) {
            V5Query query = (V5Query)v5Query;
            String queryName = query.getV5QueryName();
            if (referencedQueryNames.contains(queryName)) {
                referencedQueries.add(query);
                continue;
            }
            unReferencedQueries.add(query);
        }
        if (unReferencedQueries.size() > 0) {
            for (V5Query v5Query : referencedQueries) {
                this.findReferencedQuery(v5Query, unReferencedQueries);
            }
        }
        for (V5Query query : unReferencedQueries) {
            query.detach();
            this.removeQueryReferences(referencedQueries, query, environment);
        }
        querySet.setUnreferencedQueriesRemoved();
    }

    void removeQueryReferences(Set<V5Query> referencedQueries, V5Query query, PlanningEnvironment environment) {
        for (V5Query current : referencedQueries) {
            if (!current.getV5Source().removeQueryReference(query.getV5QueryName())) continue;
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ReferencedQueryWithoutProjectedDataItems, current.getRootQueryName(), query.getRootQueryName());
            environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
    }
}

