/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.TabStreamWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class SetTabularStreamWrapperFlag
extends Transformation {
    public SetTabularStreamWrapperFlag() {
        this.mName = "Set Tabular Stream Wrapper flag on V5Source.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String refQuery = ((V5QueryResultDefinition)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        V5Source v5Source = v5Query.getV5Source();
        v5Source.setNeedTabularStream();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        if (!v5QRD.isList()) {
            String refQuery = v5QRD.getRefQueryProperty();
            V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
            V5Query v5Query = v5QuerySet.getV5Query(refQuery);
            V5Source v5Source = v5Query.getV5Source();
            if (v5Source != null && !v5Source.needQueryOverTabularStream() && TabStreamWrapper.needTabStream((V5QueryResultDefinition)node, v5Query)) {
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "need to set tabular stream wrapper flag.", trace);
        } else {
            this.traceNodeCondition(status, "don't need tabular stream wrapper.", trace);
        }
        return status;
    }
}

