/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class ValidateV5InExpression
extends Transformation {
    public ValidateV5InExpression() {
        this.mName = "Validate V5 In Expression.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{201011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        String queryName = mdxQuery.getRefQueryProperty();
        String dataItemName = null;
        V5DataItemRef v5DataItemRef = (V5DataItemRef)node.getAncestorOfType(101015);
        if (null != v5DataItemRef) {
            dataItemName = v5DataItemRef.getDataItemRefProperty();
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidFilterExpression, queryName, dataItemName);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode detailFilterNode = node.getAncestorOfType(1010);
        if (detailFilterNode == null) {
            this.traceQueryCondition(true, "The node is not within a Cog MDX Detail Filter", trace);
            if (node.getParent() != null && node.getParent().getType() == 201066) {
                IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
                status = null != mdxQuery;
                this.traceQueryCondition(status, "The node is within V5 filter expression under an MDX query.", trace);
            }
        }
        if (!status) {
            this.traceQueryCondition(status, "The transformation is not applicable.", trace);
        }
        return status;
    }
}

