/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class BindV5DataItemReferences
extends Transformation {
    public BindV5DataItemReferences() {
        this.mName = "Bind V5 multi-part identifier to a data item.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue("isBound", "true");
        IXQEQueryNode[] identifiers = node.getDescendantsOfType(201030, false);
        V5Query currentQuery = (V5Query)node;
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, currentQuery);
        V5NameBinding nameBinding = new V5NameBinding(environment, rootQuerySet, currentQuery, null);
        for (IXQEQueryNode identifier : identifiers) {
            if (identifier.getParent().getType() == 201028) continue;
            V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)identifier;
            IXQEQueryNode boundNode = nameBinding.bindMultiPartIdentifier(multiPartIdentifier);
            if (boundNode == null) {
                multiPartIdentifier.setAttemptedBindToV5Item();
                continue;
            }
            multiPartIdentifier.exchange(boundNode, false);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        if (query.getPropertyValue("isParsed") == null) {
            return false;
        }
        if (query.getPropertyValue("isBound") != null) {
            return false;
        }
        V5Source source = (V5Source)query.getFirstChildByType(101007);
        if (null == source) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "BindV5SQLQueryItemReference requires source");
        }
        return source.getNumberChildren() <= 0 || source.getChild(0).getType() != 101016;
    }
}

