/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;
import java.util.List;

public final class BindV5Source
extends Transformation {
    public BindV5Source() {
        this.mName = "Bind V5 source to metadata connection.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101007};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IModelDataSource> dataSources;
        MetadataConnection metadataConnection = null;
        V5Source source = (V5Source)node;
        String modelPath = source.getModel();
        String modelType = source.getModelType();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (modelPath != null && (modelPath = modelPath.trim()).length() == 0) {
            modelPath = null;
            modelType = null;
        }
        if (modelPath == null) {
            try (MetadataConnectionContext mc = null;){
                V5Query query = null;
                if (environment.isMultiModelForQueryEnabled() && (query = (V5Query)source.getParent()) != null) {
                    mc = environment.pushMetadataConnectionContext(query.getMetadataPath());
                }
                if ((metadataConnection = environment.getMetadataConnection()) == null) {
                    if (mc == null && query == null) {
                        modelPath = querySet.getModelPath();
                        modelType = querySet.getModelType();
                        source.setModel(modelPath);
                        if (modelType != null) {
                            source.setModelType(modelType);
                        }
                    } else {
                        modelPath = query.getMetadataPath();
                        V5Source src = query.getV5Source();
                        modelType = null;
                        if (src != null) {
                            modelType = src.getModelType();
                        }
                    }
                } else {
                    source.setModel(metadataConnection.getModelName());
                    modelType = metadataConnection.getModelType();
                    if (modelType != null) {
                        source.setModelType(modelType);
                    }
                }
            }
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            String mcType = MetadataService.getProviderTypeFromModelPath(modelType, modelPath);
            HashSet<String> allObjNames = new HashSet<String>();
            if ("MOSER".equals(mcType)) {
                IXQEQueryNode[] objs;
                for (IXQEQueryNode o : objs = querySet.getDescendantsOfType(201030, false)) {
                    V5MultiPartIdentifier multiPart = (V5MultiPartIdentifier)o;
                    String id = multiPart.getIdentifier();
                    if (id == null || id.isEmpty()) continue;
                    allObjNames.add(id);
                }
            }
            metadataConnection = allObjNames.isEmpty() ? MetadataService.getInstance().getConnection(mcType, modelPath, execEnv, true) : MetadataService.getInstance().getConnectionForObjects(mcType, modelPath, execEnv, true, allObjNames);
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        if ((dataSources = metadataConnection.getModelDataSources()) != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        environment.setMetdataConnection(metadataConnection);
        source.setIsBound();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = !((V5Source)node).isBound();
        if (status) {
            this.traceNodeCondition(status, "The V5Source node has not been bound.", trace);
        } else {
            this.traceNodeCondition(status, "The V5Source node has been bound.", trace);
        }
        return status;
    }
}

