/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5BoundValueUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.util.V5MunUtil;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class BindV5ValueUniqueName
extends Transformation {
    public BindV5ValueUniqueName(int[] passNumbers) {
        this.mName = "Bind V5 Member Unique Name Identifier.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MemberUniqueName memberDetails = (V5MemberUniqueName)node;
        V5BoundValueUniqueName newNode = BindV5ValueUniqueName.convertV5MemberUniqueNameToV5BoundValueUniqueName(memberDetails, environment);
        if (newNode != null) {
            RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
            IXQEQueryNode dataItem = memberDetails.getAncestorOfType(101003);
            if (dataItem != null) {
                memberDetails.setPropertyValue("dataItemName", (String)dataItem.getPropertyValue("name"));
                reqEnv.addMun(memberDetails, memberDetails.getNativeName());
            } else {
                String contextName = null;
                if (memberDetails.getAncestorOfType(101008) != null) {
                    contextName = "detailFilter";
                } else if (memberDetails.getAncestorOfType(101011) != null) {
                    contextName = "summaryFilter";
                } else if (memberDetails.getAncestorOfType(101010) != null) {
                    contextName = "slicer";
                }
                if (contextName != null) {
                    memberDetails.setPropertyValue("dataItemName", contextName);
                    reqEnv.addMun(memberDetails, memberDetails.getNativeName());
                }
            }
            node.exchange(newNode, false);
        }
    }

    public static V5BoundValueUniqueName convertV5MemberUniqueNameToV5BoundValueUniqueName(V5MemberUniqueName memberDetails, PlanningEnvironment environment) {
        V5NameBinding nameBinding;
        String model = memberDetails.getModel();
        IMetadata munMetadata = memberDetails.getMetadata();
        if (munMetadata == null && (munMetadata = (nameBinding = new V5NameBinding(environment)).bindModelIdentifier(model, false)) == null) {
            V5MunUtil.setPropertyMUNBinding(memberDetails, false);
        }
        return BindV5ValueUniqueName.createBoundMUNFromV5MUNAndMetadata(memberDetails, environment, munMetadata);
    }

    private static V5BoundValueUniqueName createBoundMUNFromV5MUNAndMetadata(V5MemberUniqueName memberDetails, PlanningEnvironment environment, IMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        XQENodeFactory nf = environment.getNodeFactory();
        V5BoundValueUniqueName v5BoundValueUniqueName = (V5BoundValueUniqueName)nf.createNode(201118);
        String externalMUN = V5MunUtil.getExternalMemberUniqueName(memberDetails, false);
        v5BoundValueUniqueName.setExternalMemberUniqueName(externalMUN);
        v5BoundValueUniqueName.setMetadata(metadata);
        v5BoundValueUniqueName.setNativeName(memberDetails.getNativeName());
        if (memberDetails.getLogical() != null) {
            v5BoundValueUniqueName.setLogical(memberDetails.getLogical());
        }
        return v5BoundValueUniqueName;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5MemberUniqueName memberDetails = (V5MemberUniqueName)node;
        if (V5MunUtil.isMunBindingFailed(memberDetails)) {
            this.traceNodeCondition(false, "The V5MemberUniqueName node binding failed.", trace);
            return false;
        }
        if (memberDetails.getMetadata() instanceof IQueryItemOfQuerySubject) {
            this.traceNodeCondition(true, "The node is a valid V5MemberUniqueName node that can be converted to V5BoundValueUniqueName.", trace);
            return true;
        }
        this.traceNodeCondition(false, "BindV5MemberUniqueName should be applied.", trace);
        return false;
    }
}

