/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.v5.query.V5MdProjectedItem;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.ast.v5.query.V5XmlQuery;
import com.cognos.xqe.ast.v5.query.V5XmlText;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;

public final class BindV5XmlQuery
extends Transformation {
    public BindV5XmlQuery() {
        this.mName = "Bind V5 XML query.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{101067};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RowType rowType = DataTypeFactory.getRowType();
        IXQEQueryNode[] children = node.getChildrenOfTypeOrdered(101069);
        ArrayList<String> nameList = new ArrayList<String>(children.length);
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode child = children[i];
            String name = (String)child.getPropertyValue("name");
            IDataType dType = DataTypeFactory.getType((String)child.getPropertyValue("type"));
            rowType.addField(name, dType);
            nameList.add(name);
            child.extract();
        }
        SQLTableFunction tableFunction = (SQLTableFunction)nodeFactory.createNode(301038);
        tableFunction.setSubType(SQLTableFunction.SubType.XMLTABLE);
        tableFunction.setDataType(rowType);
        V5XmlText xmlText = (V5XmlText)node.getChild(0);
        String xmlTextValue = (String)xmlText.getPropertyValue("xQueryText");
        SQLLiteral xmlQuery = (SQLLiteral)nodeFactory.createNode(301031);
        xmlQuery.setDataType(DataTypeFactory.getCharType(xmlTextValue.length()));
        xmlQuery.setValue(xmlTextValue);
        tableFunction.addChild(xmlQuery);
        for (int i = 0; i < nameList.size(); ++i) {
            IXQEQueryNode child = children[i];
            String path = (String)child.getPropertyValue("path");
            SQLLiteral xPath = (SQLLiteral)nodeFactory.createNode(301031);
            xPath.setDataType(DataTypeFactory.getCharType(path.length()));
            xPath.setValue(path);
            tableFunction.addChild(xPath);
        }
        xmlText.exchange(tableFunction);
        V5SqlQuery sqlQuery = (V5SqlQuery)nodeFactory.createNode(101016);
        sqlQuery.setPropertyValue("name", ((V5XmlQuery)node).getName());
        for (int i = 0; i < nameList.size(); ++i) {
            String name = (String)nameList.get(i);
            V5MdProjectedItem item = (V5MdProjectedItem)nodeFactory.createNode(101041);
            item.setPropertyValue("name", name);
            sqlQuery.addChild(item);
        }
        node.exchange(sqlQuery, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getChild(0).getType() != 301004) {
            status = true;
            this.traceQueryCondition(status, "The V5 XML query has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "The V5 XML query has been bound.", trace);
        }
        return status;
    }
}

