/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.v5.query.V5StoredProcedure;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.List;

public class ConvertStoredProcedureToAST
extends Transformation {
    public ConvertStoredProcedureToAST() {
        this.mName = "Convert Stored Procedure to AST";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101075};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ICatalog catalog;
        String schemaName;
        String[] parts;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        V5StoredProcedure v5StoredProcedure = (V5StoredProcedure)node;
        String procName = (String)v5StoredProcedure.getPropertyValue("canonicalName");
        SQLCall sqlCall = (SQLCall)nodeFactory.createNode(301061);
        sqlCall.setName(procName);
        String dsRef = (String)v5StoredProcedure.getPropertyValue("dataSourceRef");
        try {
            parts = UniqueNameParser.parse(dsRef, -1);
        }
        catch (UniqueNameParserException e) {
            return;
        }
        dsRef = parts[parts.length - 1];
        MetadataConnection mdConnection = environment.getMetadataConnection();
        List<IModelDataSource> modelDSs = mdConnection.getModelDataSources();
        IModelDataSource modelDS = RQPUtilities.getModelDataSource(modelDSs, dsRef);
        IDataSource dataSource = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getOrAddDataSource(modelDS);
        sqlCall.setDataSource(dataSource);
        String cmDatabaseName = dataSource.getCMDataSourceName();
        if (cmDatabaseName != null) {
            if (MacroExpander.isMacro(cmDatabaseName)) {
                sqlCall.setRawCmDatabaseName(cmDatabaseName);
                MacroExpander expander = new MacroExpander();
                cmDatabaseName = expander.expand(null, environment, cmDatabaseName);
            }
            sqlCall.setDatabaseName(cmDatabaseName);
        }
        if ((schemaName = modelDS.getSchema()) != null) {
            if (MacroExpander.isMacro(schemaName)) {
                sqlCall.setRawSchemaName(schemaName);
                MacroExpander expander = new MacroExpander();
                schemaName = expander.expand(null, environment, schemaName);
            }
            sqlCall.setSchemaName(schemaName);
        }
        if ((catalog = modelDS.getCatalog()) != null) {
            void var17_20;
            String string = catalog.getUniqueName();
            if (MacroExpander.isMacro(string)) {
                sqlCall.setRawCatalogName(string);
                MacroExpander expander = new MacroExpander();
                String string2 = expander.expand(null, environment, string);
            }
            sqlCall.setCatalogName((String)var17_20);
        }
        for (IXQEQueryNode child : v5StoredProcedure.getChildren()) {
            if (child.getType() != 101076) continue;
            String paramName = (String)child.getPropertyValue("name");
            String paramDatatype = (String)child.getPropertyValue("datatype");
            String paramPrecision = (String)child.getPropertyValue("precision");
            String paramScale = (String)child.getPropertyValue("scale");
            String paramNullable = (String)child.getPropertyValue("nullable");
            String paramValue = (String)child.getPropertyValue("value");
            String mode = (String)child.getPropertyValue("mode");
            Boolean nullable = true;
            if (paramNullable != null && (paramNullable.length() == 0 || paramNullable.equals("0"))) {
                nullable = false;
            }
            if (paramValue == null && !nullable.booleanValue()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_StoredProcedureBadParameterValue, "NULL", paramName);
            }
            if (paramValue != null && MacroExpander.isMacro(paramValue)) {
                MacroExpander expander = new MacroExpander();
                paramValue = expander.expand(child, environment, paramValue);
            }
            int scale = 0;
            if (paramScale != null && !paramScale.isEmpty()) {
                scale = Integer.parseInt(paramScale);
            }
            int precision = 0;
            if (paramPrecision != null && !paramPrecision.isEmpty()) {
                precision = Integer.parseInt(paramPrecision);
            }
            IDataType datatype = MetadataUtil.constructDatatype(paramDatatype, scale, precision);
            int len = 0;
            if (paramValue != null) {
                len = paramValue.length();
            }
            if (paramValue != null && len > 2 && paramValue.charAt(0) == '?' && paramValue.charAt(len - 1) == '?') {
                String promptName = paramValue.substring(1, len - 1);
                SQLParameter sqlParameter = (SQLParameter)nodeFactory.createNode(301051);
                sqlParameter.setName(promptName);
                sqlParameter.setDataType(datatype);
                sqlParameter.setUseParameterizedSQL(true);
                sqlParameter.setMode(mode);
                Parameters parameters = reqEnv.getRequestParameters();
                Parameter envParam = parameters.getParameter(promptName);
                if (envParam != null) {
                    if (envParam.getDataType() == null) {
                        envParam.setDataType(datatype);
                    }
                } else {
                    envParam = new Parameter(promptName);
                    envParam.setDataType(datatype);
                    parameters.addParameter(promptName, envParam);
                }
                sqlCall.addChild(sqlParameter);
                continue;
            }
            if (mode.equalsIgnoreCase("IN") && paramValue == null) {
                SQLLiteral sqlLiteral = (SQLLiteral)nodeFactory.createNode(301031);
                sqlLiteral.setDataType(datatype);
                sqlLiteral.setValue(paramValue);
                sqlCall.addChild(sqlLiteral);
                continue;
            }
            SQLParameter sqlParameter = (SQLParameter)nodeFactory.createNode(301051);
            datatype = RQPUtilities.promoteDataType(datatype, paramValue);
            Value dataValue = (Value)datatype.createValue();
            dataValue.set(paramValue);
            sqlParameter.setInValue(dataValue.getString());
            sqlParameter.setName(paramName);
            sqlParameter.setDataType(datatype);
            sqlParameter.setMode(mode);
            sqlCall.addChild(sqlParameter);
        }
        Parameters parameters = reqEnv.getRequestParameters();
        if (!parameters.getUnresolvedParameters().isEmpty()) {
            throw new UnresolvedParameterException(reqEnv, null, reqEnv.getRequestParameters().getUnresolvedParameters());
        }
        v5StoredProcedure.exchange(sqlCall);
    }
}

