/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5.V5NodeTypeEnum;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ConvertV5ExpressionToBinary
extends Transformation {
    public static final String PROP_IS_INVALID_EXPRESSION = "isInvalidExpression";
    public static final String PROP_V5_QUERY_IDENTIFIER = "v5QueryIdentifier";
    private static final String STR_CLOSE_CURLY_BRACKET = "}";
    public static final String STR_POUND = "#";
    private static final String STR_DYNAMIC_SCOPED_TO = "DynamicScopedTo=";
    private static final String STR_DI = "dataItem";
    private static final String STR_AT = "applyTo";

    public ConvertV5ExpressionToBinary() {
        this.mName = "Convert V5 expression to binary.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        ArrayList<IXQEQueryNode> nodesToParse = new ArrayList<IXQEQueryNode>();
        V5QuerySet querySet = (V5QuerySet)node.getParent();
        List<V5QueryResultDefinition> qrds = querySet.getReferencedQRDs((V5Query)node);
        for (V5QueryResultDefinition qrd : qrds) {
            nodesToParse.addAll(Arrays.asList(qrd.getDescendantsOfType(101054, false)));
        }
        int[] types = new int[]{101025, 101027, 101004, 101013, 101014};
        nodesToParse.addAll(Arrays.asList(node.getDescendantsOfTypes(types, false)));
        node.setPropertyValue("isParsed", "true");
        Iterator iterator = nodesToParse.iterator();
        while (iterator.hasNext()) {
            IXQEQueryNode nodeToParse;
            IXQEQueryNode expressionContext = nodeToParse = (IXQEQueryNode)iterator.next();
            if (nodeToParse.getType() == 101004) {
                expressionContext = nodeToParse.getParent();
            }
            if (expressionContext.getType() == 101003 && !((V5DataItem)expressionContext).isReferenced()) continue;
            Object prop = nodeToParse.getPropertyValue("expression");
            nodeToParse.removeProperty("expression");
            if (!(prop instanceof String) || nodeToParse.getNumberChildren() != 0) continue;
            String exp = (String)prop;
            MetadataConnectionContext metadataConnContext = null;
            try {
                IXQEQueryNode enode;
                MetadataContext metadataContext;
                boolean dynamicScopedToApplied = this.setUpDynamicScopedTo(query, exp, nodeToParse);
                if (!dynamicScopedToApplied && exp.contains("$ApplyToDynamicSQS{")) {
                    String applyToValue = ConvertV5ExpressionToBinary.getApplyToValue(environment, exp);
                    int[] ancestorTypes = new int[]{101008, 101003, 101011, 101010};
                    IXQEQueryNode ancestor = nodeToParse.getAncestorOfTypes(ancestorTypes);
                    if (ancestor != null) {
                        ancestor.setPropertyValue("applyToDSQS", applyToValue);
                    }
                }
                if ((metadataContext = (MetadataContext)nodeToParse.getPropertyValue("metadataContext")) == null) {
                    IMetadataContextManager mcMgr;
                    MetadataConnection conn;
                    metadataConnContext = environment.pushMetadataConnectionContext(query);
                    String mcName = (String)nodeToParse.getPropertyValue("metadataContextName");
                    if (mcName != null && (conn = environment.getMetadataConnection()) != null && (mcMgr = conn.getMetadataContextManager()) != null) {
                        metadataContext = mcMgr.getExistingMetadataContext(mcName);
                    }
                }
                if (exp.contains(STR_POUND)) {
                    MacroExpander expander = new MacroExpander();
                    exp = expander.expand(nodeToParse, environment, exp);
                }
                if ((enode = ConvertV5ExpressionToBinary.precheckMoserCalculatedQueryItem(environment, nodeToParse, exp)) == null) {
                    enode = V5ExpressionProcessor.process(exp, environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale(), expressionContext, metadataContext == null);
                }
                if (enode != null) {
                    if (enode.getType() == 201030) {
                        enode.setPropertyValue(PROP_V5_QUERY_IDENTIFIER, Boolean.TRUE);
                    }
                    nodeToParse.addChild(enode);
                }
                if (metadataContext == null) continue;
                metadataContext.setMetadataContextOnV5MultiPartIdentifier(nodeToParse.getChild(0));
            }
            catch (XQERuntimeException xre) {
                ConvertV5ExpressionToBinary.handleException(environment, xre, nodeToParse, exp);
            }
            finally {
                if (metadataConnContext == null) continue;
                metadataConnContext.close();
            }
        }
    }

    public static void handleException(PlanningEnvironment environment, XQERuntimeException xre, IXQEQueryNode nodeToParse, String exp) {
        if (((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
            ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, xre), nodeToParse, environment.getRoot());
            nodeToParse.setPropertyValue(PROP_IS_INVALID_EXPRESSION, true);
            if (exp.isEmpty() || ConvertV5ExpressionToBinary.containsWhitespsacesOnly(exp)) {
                String v5ElementName = V5NodeTypeEnum.getV5NodeName(nodeToParse.getNodeType());
                ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.V5_SyntaxErrorEmptyExpression, v5ElementName), nodeToParse, environment.getRoot());
            }
        } else {
            if (exp.isEmpty() || ConvertV5ExpressionToBinary.containsWhitespsacesOnly(exp)) {
                String v5ElementName = V5NodeTypeEnum.getV5NodeName(nodeToParse.getNodeType());
                throw new XQERuntimeException(XQEMessageKeys.V5_SyntaxErrorEmptyExpression, (Throwable)xre, v5ElementName);
            }
            throw xre;
        }
        nodeToParse.addChild(environment.getNodeFactory().createNode(201023));
    }

    public static IXQEQueryNode precheckMoserCalculatedQueryItem(PlanningEnvironment env, IXQEQueryNode nodeToParse, String exp) {
        if (!((RequestEnvironment)env.getRequestEnvironment()).isValidateRequest()) {
            return null;
        }
        if (!"validateAll".equals(((RequestEnvironment)env.getRequestEnvironment()).getOperationName())) {
            return null;
        }
        if (nodeToParse.getType() != 101004) {
            return null;
        }
        IXQEQueryNode p = nodeToParse.getParent();
        if (p == null || p.getType() != 101003) {
            return null;
        }
        V5DataItem di = (V5DataItem)p;
        IMetadata md = (IMetadata)di.getPropertyValue("contextMetadata");
        if (!(md instanceof MoserCalculation)) {
            return null;
        }
        MoserCalculation calc = (MoserCalculation)md;
        XQERuntimeException e = MoserModuleUtil.preCheckCalculatedQueryItem(calc, exp);
        if (e == null) {
            return null;
        }
        ((RequestEnvironment)env.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, e), di, env.getRoot());
        return env.getNodeFactory().createNode(201023);
    }

    private boolean setUpDynamicScopedTo(V5Query query, String exp, IXQEQueryNode nodeToParse) {
        int idx = exp.indexOf(STR_DYNAMIC_SCOPED_TO);
        if (idx == -1) {
            return false;
        }
        String s = exp.substring(idx + STR_DYNAMIC_SCOPED_TO.length());
        if ((idx = s.lastIndexOf(STR_CLOSE_CURLY_BRACKET)) == -1) {
            return false;
        }
        s = s.substring(0, idx + 1);
        JSONObject jObj = null;
        try {
            jObj = OrderedJSONObject.parse((String)s);
            if (jObj.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidDynamicScopedToJSON, s, e.getMessage());
        }
        HashMap<String, Pair> dynamicScopes = new HashMap<String, Pair>();
        Set keys = jObj.keySet();
        for (Object k : keys) {
            String applyTo;
            String diName;
            JSONObject inclObj;
            int i;
            JSONObject v = (JSONObject)jObj.get(k);
            String kName = (String)k;
            JSONArray incl = (JSONArray)v.get((Object)"incl");
            JSONArray excl = (JSONArray)v.get((Object)"excl");
            if ((incl == null || incl.isEmpty()) && (excl == null || excl.isEmpty())) continue;
            Pair p = new Pair(new HashSet(), new HashSet());
            if (incl != null && !incl.isEmpty()) {
                for (i = 0; i < incl.size(); ++i) {
                    inclObj = (JSONObject)incl.get(i);
                    diName = (String)inclObj.get((Object)STR_DI);
                    this.checkDataItemExist(s, query, diName);
                    applyTo = (String)inclObj.get((Object)STR_AT);
                    ((Set)p.getFirst()).add(new Pair(diName, applyTo));
                }
            }
            if (excl != null && !excl.isEmpty()) {
                for (i = 0; i < excl.size(); ++i) {
                    inclObj = (JSONObject)excl.get(i);
                    diName = (String)inclObj.get((Object)STR_DI);
                    this.checkDataItemExist(s, query, diName);
                    applyTo = (String)inclObj.get((Object)STR_AT);
                    ((Set)p.getSecond()).add(new Pair(diName, applyTo));
                }
            }
            dynamicScopes.put(kName, p);
        }
        if (dynamicScopes.isEmpty()) {
            return false;
        }
        IXQEQueryNode di = nodeToParse.getAncestorOfType(101003);
        if (di == null) {
            return false;
        }
        HashMap<String, HashMap<String, Pair>> globalMap = (HashMap<String, HashMap<String, Pair>>)query.getPropertyValue("DynamicScopedTo");
        if (globalMap == null) {
            globalMap = new HashMap<String, HashMap<String, Pair>>();
            query.setPropertyValue("DynamicScopedTo", globalMap);
        }
        String diName = ((V5DataItem)di).getNameProperty();
        globalMap.put(diName, dynamicScopes);
        return true;
    }

    private void checkDataItemExist(String dst, V5Query query, String diName) {
        if (diName == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidDynamicScopedToNoDataItem, dst, STR_DI);
        }
        if (query.getDataItemByName(diName) == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidDynamicScopedTo, dst, diName);
        }
    }

    public static String getApplyToValue(PlanningEnvironment env, String exp) {
        String parameterMapExpr = ConvertV5ExpressionToBinary.getParameterMapExpr(exp);
        MacroExpander expander = new MacroExpander();
        String applyToValue = expander.expand(null, env, parameterMapExpr);
        String[] splits = applyToValue.split(";");
        try {
            for (String s : splits) {
                UniqueNameParser.parse(s);
            }
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidApplyToInformation, exp, "apply to");
        }
        return applyToValue;
    }

    public static String getParameterMapExpr(String exp) {
        int start = exp.indexOf("$ApplyToDynamicSQS{");
        String theRest = exp.substring(start, exp.length());
        int end = theRest.indexOf(STR_CLOSE_CURLY_BRACKET);
        String parameterMapExpr = STR_POUND + exp.substring(start, start + end + 1) + STR_POUND;
        return parameterMapExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!((V5Query)node).isReferenced()) {
            return false;
        }
        return null == node.getPropertyValue("isParsed");
    }

    public static boolean containsWhitespsacesOnly(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

