/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.LoopDetectionChain;

public class CopyModelCalculationExpressions
extends Transformation {
    public static final String LOOP_DETECTED = "loop detected";

    public CopyModelCalculationExpressions(int[] passNumbers) {
        this.mName = "Copy model calculation expression";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
        V5DataItem refDataItem = dataItemRef.getRefDataItem();
        IXQEQueryNode clonedExpr = null;
        if (dataItemRef.getPropertyValue("copyOnlyCalculationExpression") != null) {
            clonedExpr = nodeFactory.deepCopyNode(refDataItem.getDetailExpression());
        } else {
            LoopDetectionChain ldc = new LoopDetectionChain();
            ldc.push((String)refDataItem.getPropertyValue("refModelObjectName"));
            for (IXQEQueryNode parent = dataItemRef.getParent(); parent != null && parent.getType() != 101009; parent = parent.getParent()) {
                if (parent.getType() != 101003) continue;
                V5DataItem di = (V5DataItem)parent;
                String refName = (String)di.getPropertyValue("refModelObjectName");
                if (refName != null) {
                    ldc.push(refName);
                }
                if (!di.getId().equals(refDataItem.getId())) continue;
                if (((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
                    IMessageKey.Param1 msgParam = XQEMessageKeys.PLN_LoopInModelExpression;
                    ResponseMessage msg = new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, msgParam, ldc.serialize());
                    ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(msg, node, null);
                    node.setPropertyValue(LOOP_DETECTED, true);
                    IXQEQueryNode nullNode = environment.getNodeFactory().createNode(201023);
                    node.exchange(nullNode);
                    return;
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInModelExpression, ldc.serialize());
            }
            clonedExpr = (V5DataItem)nodeFactory.deepCopyNode(refDataItem);
            if (refDataItem.getPropertyValue("copyOnlyCalculationExpression") != null) {
                clonedExpr.removeProperty("copyOnlyCalculationExpression");
            }
        }
        dataItemRef.exchange(clonedExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("modelCalculationRef") == null) {
            this.traceQueryCondition(false, "This reference is not a calculation reference.", trace);
            return false;
        }
        if (node.getPropertyValue(LOOP_DETECTED) != null) {
            this.traceQueryCondition(false, "Loop was detected and already reported", trace);
            return false;
        }
        this.traceQueryCondition(true, "This reference is a calculation reference.", trace);
        return true;
    }
}

