/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQueryItemFolder;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ExpandModelFilters
extends Transformation {
    public ExpandModelFilters() {
        this.mName = "Expand standalone model filters";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IFilter filter = (IFilter)this.getModelFilter(v5BoundID);
        IXQEQueryNode itemExpr = RQPUtilities.getV5ValueExpression(filter, environment);
        boolean bPush = false;
        try {
            bPush = this.pushMoserQuerySubject(filter, environment);
            if (bPush) {
                itemExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, itemExpr);
            }
        }
        finally {
            if (bPush) {
                environment.popSymbolTable();
            }
        }
        node.exchange(itemExpr);
    }

    private boolean pushMoserQuerySubject(IFilter filter, PlanningEnvironment environment) {
        if (!(filter instanceof MoserFilter)) {
            return false;
        }
        MoserFilter moserFilter = (MoserFilter)filter;
        IMetadata parent = moserFilter.getParentObject();
        if (parent instanceof MoserQuerySubject || parent instanceof MoserQueryItem || parent instanceof MoserQueryItemFolder) {
            if (parent instanceof MoserQueryItem) {
                parent = ((MoserQueryItem)parent).getQuerySubject();
            } else if (parent instanceof MoserQueryItemFolder) {
                parent = ((MoserQueryItemFolder)parent).getQuerySubject();
            }
            environment.pushSymbolTable(new SymbolTableForQS((MoserQuerySubject)parent, moserFilter, true));
            return true;
        }
        return false;
    }

    private IMetadata getModelFilter(V5BoundModelIdentifier id) {
        IMetadata metaData = id.getMetadata();
        if (metaData == null) {
            return null;
        }
        while (MetadataType.SHORTCUT == metaData.getObjectType()) {
            metaData = ((IShortcut)id.getMetadata()).getTarget();
        }
        if (MetadataType.FILTER == metaData.getObjectType()) {
            return metaData;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (null != this.getModelFilter(v5BoundID)) {
            this.traceNodeCondition(true, "Standalone filter will be replaced by its expression.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Not a standalone filter.", xqeTrace);
        return false;
    }
}

