/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ExpandModelItemsInSelectiontHavingAtClause
extends Transformation {
    public static final String HAS_DATAITEM_ATCLAUSE_IN_EXPR = "HasDataItemWithATClauseInExpr";

    public ExpandModelItemsInSelectiontHavingAtClause() {
        this.mName = "Expand model items in selection having AT clause";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        V5Selection selection = (V5Selection)v5BoundID.getAncestorOfType(101009);
        if (selection.getPropertyValue(HAS_DATAITEM_ATCLAUSE_IN_EXPR) == null) {
            selection.setPropertyValue(HAS_DATAITEM_ATCLAUSE_IN_EXPR, Boolean.TRUE);
        }
        V5DataItem v5DataItem = this.createV5DataItem(environment, v5BoundID);
        node.exchange(v5DataItem);
    }

    private V5DataItem createV5DataItem(PlanningEnvironment environment, V5BoundModelIdentifier boundID) {
        V5DataItem v5DataItem = (V5DataItem)environment.getNodeFactory().createNode(101003);
        v5DataItem.setNameProperty(this.getModelQueryItem(boundID).getCaption());
        IXQEQueryNode itemExpr = boundID.getV5ValueExpression(environment);
        v5DataItem.addChild(itemExpr);
        return v5DataItem;
    }

    private IMetadata getModelQueryItem(V5BoundModelIdentifier id) {
        IMetadata metaData = id.getMetadata();
        if (metaData == null) {
            return null;
        }
        while (MetadataType.SHORTCUT == metaData.getObjectType()) {
            metaData = ((IShortcut)metaData).getTarget();
        }
        if (metaData instanceof IQueryItemOfQuerySubject) {
            return metaData;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if ("module".equals(environment.getMetadataConnection().getModelType())) {
            this.traceNodeCondition(false, "Data item not expanded for model type of module.", xqeTrace);
            return false;
        }
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        V5Selection selection = (V5Selection)v5BoundID.getAncestorOfType(101009);
        if (null == selection) {
            this.traceNodeCondition(false, "Data item not expanded if not under selection.", xqeTrace);
            return false;
        }
        if (null == this.getModelQueryItem(v5BoundID)) {
            this.traceNodeCondition(false, "Data item not expanded if it is not a queryItem of querySubject.", xqeTrace);
            return false;
        }
        IXQEQueryNode itemExpr = v5BoundID.getV5ValueExpression(environment);
        if (null != selection.getPropertyValue(HAS_DATAITEM_ATCLAUSE_IN_EXPR) && null != itemExpr) {
            this.traceNodeCondition(true, "Selection has at least one data item with AT clause.  Data item will be expanded.", xqeTrace);
            return true;
        }
        if (null != itemExpr && null != itemExpr.getFirstChildByType(201036)) {
            this.traceNodeCondition(true, "Data item has an AT clause in its expression.  It will be expanded.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Data item will not be expanded.", xqeTrace);
        return false;
    }
}

