/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqemoser.MoserMember;
import com.cognos.xqemoser.time.MoserTimePeriod;
import com.cognos.xqemoser.time.MoserTimeUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ExpandMoserCalculatedMember
extends Transformation {
    public ExpandMoserCalculatedMember() {
        this.mName = "Expand moser calculated member to v5 member";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        MoserMember moserMember = (MoserMember)v5BoundID.getMetadata();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode itemExpr = V5ExpressionProcessor.process(moserMember.getExpression(), environment, environment.getMetadataConnection().getDefaultLocale(moserMember), null, true);
        IXQEQueryNode newExpr = null;
        IHierarchy hier = moserMember.getHierarchy();
        newExpr = hier != null ? this.createV5Member(nodeFactory, itemExpr, moserMember) : this.createCalculation(environment, itemExpr, moserMember);
        node.exchange(newExpr);
    }

    protected IXQEQueryNode createV5Member(XQENodeFactory nodeFactory, IXQEQueryNode itemExpr, MoserMember moserMember) {
        IXQEQueryNode v5Member = nodeFactory.createNode(201085);
        v5Member.addChild(itemExpr);
        V5LiteralValue munV = (V5LiteralValue)nodeFactory.createNode(201026);
        String mun = moserMember.getV5UniqueName();
        munV.setDataType(DataTypeFactory.getVarcharType(mun.length()));
        munV.setValue(mun);
        v5Member.addChild(munV);
        V5LiteralValue capV = (V5LiteralValue)nodeFactory.createNode(201026);
        String caption = moserMember.getCaption();
        capV.setDataType(DataTypeFactory.getVarcharType(caption.length()));
        capV.setValue(caption);
        v5Member.addChild(capV);
        V5BoundModelIdentifier mIdentifier = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        mIdentifier.setMetadata(moserMember.getHierarchy());
        mIdentifier.setIdentifier(moserMember.getHierarchy().getV5UniqueName());
        v5Member.addChild(mIdentifier);
        return v5Member;
    }

    protected IXQEQueryNode createCalculation(PlanningEnvironment environment, IXQEQueryNode itemExpr, MoserMember moserMember) {
        if (itemExpr.getType() != 201030) {
            return itemExpr;
        }
        V5MultiPartIdentifier idNode = (V5MultiPartIdentifier)itemExpr;
        IMetadata md = environment.getMetadataConnection().bindMetadataReference(idNode.getNativeName());
        if (!(md instanceof MoserTimePeriod)) {
            return itemExpr;
        }
        IXQEQueryNode newExpr = MoserTimeUtil.createCalculation(environment, moserMember, (MoserTimePeriod)md);
        if (newExpr == null) {
            return itemExpr;
        }
        return newExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (v5BoundID.getMetadata() instanceof MoserMember) {
            this.traceNodeCondition(true, "Moser calculated member will be replaced by its expression.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Not a Moser calculated member.", xqeTrace);
        return false;
    }
}

