/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;

public final class IdentifyOriginalDataItems
extends Transformation {
    public IdentifyOriginalDataItems() {
        this.mName = "Identify Original Data Item.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem dataItem = (V5DataItem)node;
        dataItem.setIsOriginal();
        if (ExpandDataItemReferences.generateSubqueryForCalc(node, environment)) {
            dataItem.setCalculationExpression();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem dataItem = (V5DataItem)node;
        if (dataItem.isOriginal()) {
            this.traceNodeCondition(false, "The data item is already marked as original.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item is not marked as original.", trace);
        return true;
    }
}

