/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class LogV5SpecificationGeneration
extends Transformation {
    public LogV5SpecificationGeneration() {
        this.mName = "LogV5SpecificationGeneration";
        this.mPassNumbers = new int[]{21};
        this.mTypes = new int[]{101002};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        TraceLogManager.getInstance().logV5QuerySet((V5QuerySet)node, reqEnv);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String subRequestId;
        XQETrace trace = environment.getTrace();
        if (!QueryEngineLoggingUtils.isLogV5SubquerySpecificationGenerationTraceEnabled(environment.getMultiRequestContext())) {
            this.traceQueryCondition(false, "The logging is not enabled.", trace);
            return false;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        String requestId = reqEnv.getRequestID();
        if (!TraceLogManager.isSubRequest(requestId, subRequestId = reqEnv.getSubRequestID())) {
            this.traceQueryCondition(false, "The query is not a subquery.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5 Query is a subquery and logging is enabled.", trace);
        return true;
    }
}

