/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveUnreferencedDataItems
extends Transformation {
    public RemoveUnreferencedDataItems() {
        this.mName = "Remove unreferenced data items.";
        this.mPassNumbers = new int[]{25};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem dataItem = (V5DataItem)node;
        if (dataItem.isReferenced()) {
            this.traceNodeCondition(false, "The data item is referenced.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item is not referenced.", trace);
        return true;
    }
}

