/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class CoerceCheckToHierarchy
extends Transformation {
    public static final int MEMBER_HIERARCHY_CHILD = 3;

    public CoerceCheckToHierarchy() {
        this.mName = "Coerce Check To Hierarchy";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201099, 201100, 201059, 201061, 201083, 201085};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int childPos = this.requiresCoercionCheckToHierarchy(node);
        IXQEQueryNode child = node.getChild(childPos);
        V5ExpressionCheck.throwInvalidCoercionException(child, V5ExpressionTypeEnum.HIERARCHY);
    }

    public int requiresCoercionCheckToHierarchy(IXQEQueryNode node) {
        int status = -1;
        int child = 0;
        if (node.getType() == 201085) {
            child = 3;
        }
        if (child + 1 <= node.getNumberChildren()) {
            IXQEQueryNode childNode = node.getChild(child);
            while (childNode.getType() == 101003) {
                childNode = childNode.getChild(0);
            }
            if (!V5ExpressionCheck.isHierarchyExpression(childNode)) {
                status = child;
            }
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int status = this.requiresCoercionCheckToHierarchy(node);
        if (status == -1) {
            this.traceNodeCondition(false, "There are no issues with checking for Hierarchy context", trace);
        } else {
            this.traceNodeCondition(true, "Child at position " + String.valueOf(status) + " can not be coerced to HIERARCHY.", trace);
        }
        return status != -1;
    }
}

