/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataConstants;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.CalculatedMemberUnwindException;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserQueryItem;

public class CoerceCheckToMember
extends Transformation {
    public CoerceCheckToMember() {
        this.mName = "Coerce Check To Member";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201045, 201046, 201053, 201054, 201057, 201067, 201068, 201077, 201078, 201079, 201080, 201081, 201082, 201088, 201090, 201093, 201094, 201095, 201096, 201102, 201148, 201110, 201056, 201101};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int childPos = this.requiresCoercionCheckToMember(node, environment);
        IXQEQueryNode child = node.getChild(childPos);
        V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(child);
        if (expressionType == V5ExpressionTypeEnum.VALUE && child.getType() == 201024) {
            String paramName = ((V5Parameter)child).getValue();
            XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_InvalidPromptOrPromptmanyFormat, paramName, child);
            throw new CalculatedMemberUnwindException(message);
        }
        V5ExpressionCheck.throwInvalidCoercionException(child, V5ExpressionTypeEnum.MEMBER);
    }

    public int requiresCoercionCheckToMember(IXQEQueryNode node, PlanningEnvironment environment) {
        int status = -1;
        int child = 0;
        if (node.getType() == 201079 || node.getType() == 201095 || node.getType() == 201054 || node.getType() == 201090) {
            child = 1;
        }
        if (node.getType() == 201093) {
            child = 2;
        }
        while (child + 1 <= node.getNumberChildren()) {
            IXQEQueryNode childNode = node.getChild(child);
            while (childNode.getType() == 101003) {
                childNode = childNode.getChild(0);
            }
            if (!this.treatFactQueryItemInDMRasMeasure(node, childNode, environment)) {
                if (!V5ExpressionCheck.isMemberExpression(childNode)) {
                    status = child;
                    break;
                }
                if (!node.isOfCategories(new int[]{201057, 201123, 201101})) break;
            }
            ++child;
        }
        return status;
    }

    protected boolean treatFactQueryItemInDMRasMeasure(IXQEQueryNode node, IXQEQueryNode childNode, PlanningEnvironment environment) {
        MetadataConnection mdConn = environment.getMetadataConnection();
        if (!(mdConn instanceof MoserMetadataConnection)) {
            return false;
        }
        if (node.getType() != 201110) {
            return false;
        }
        IXQEQueryNode q = node.getAncestorOfType(101006);
        if (q == null || !((V5Query)q).isDMR()) {
            return false;
        }
        int tp = childNode.getType();
        if (tp == 201032) {
            return true;
        }
        if (tp != 201116) {
            return false;
        }
        V5BoundModelIdentifier mdObj = (V5BoundModelIdentifier)childNode;
        IMetadata meta = mdObj.getMetadata();
        if (meta == null) {
            return false;
        }
        if (meta instanceof MoserQueryItem) {
            MoserQueryItem moserQI = (MoserQueryItem)meta;
            return MetadataConstants.FACT.equals(moserQI.getUsage());
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int status = -1;
        if (!this.getTransformationLibrary().getLibraryName().equals("PrePlanV5TransformationLibrary")) {
            status = this.requiresCoercionCheckToMember(node, environment);
        }
        if (status == -1) {
            this.traceNodeCondition(false, "There are no issues with checking for MEMBER context", trace);
        } else {
            this.traceNodeCondition(true, String.valueOf(status) + " child node can not be coerced to MEMBER.", trace);
        }
        return status != -1;
    }
}

