/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceSetExpression;

public class CoerceSetInExpression
extends AbstractCoerceSetExpression {
    public CoerceSetInExpression() {
        this.mName = "Coerce Set Expression for all arguments";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode rhsNode;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode lhsNode = node.getChild(0);
        if (!V5ExpressionCheck.isSetExpression(lhsNode)) {
            CoerceSetInExpression.coerceToSetExpression(node.getChild(0), nodeFactory);
        }
        if (node.getNumberChildren() == 2 && !V5ExpressionCheck.isSetExpression(rhsNode = node.getChild(1)) && !V5ExpressionCheck.isMemberExpression(rhsNode)) {
            CoerceSetInExpression.coerceToSetExpression(rhsNode, nodeFactory);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5query;
        XQETrace trace = environment.getTrace();
        int numberOfChildren = node.getNumberChildren();
        if (numberOfChildren < 2) {
            node.throwInternalError("At least 2 child nodes expected.");
        }
        if ((v5query = (V5Query)node.getAncestorOfType(101006)) == null) {
            this.traceNodeCondition(false, "The '='/'<>' condition node isn't in a query", trace);
            return false;
        }
        if (v5query.isTabular()) {
            this.traceNodeCondition(false, "The '='/'<>' condition node isn't in an OLAP query", trace);
            return false;
        }
        IXQEQueryNode lhsNode = node.getChild(0);
        if (V5ExpressionCheck.isValueExpression(lhsNode)) {
            this.traceNodeCondition(false, "The IN condition node has a LHS which is a value expression.", trace);
            return false;
        }
        boolean coercionRequired = this.requiresSetCoercion(lhsNode);
        IXQEQueryNode firstRhsNode = node.getChild(1);
        if (!coercionRequired && numberOfChildren == 2) {
            boolean firstRhsIsSet = V5ExpressionCheck.isSetExpression(firstRhsNode);
            boolean rhsIsMember = V5ExpressionCheck.isMemberExpression(firstRhsNode);
            if (firstRhsIsSet || rhsIsMember) {
                this.traceNodeCondition(false, "The IN condition has a LHS which is a set expression and the RHS is a set/member expression", trace);
                return false;
            }
            coercionRequired = this.requiresSetCoercion(firstRhsNode);
        }
        if (coercionRequired) {
            this.traceNodeCondition(true, "The IN condition requires coercion", trace);
        } else {
            this.traceNodeCondition(false, "The IN condition doesn't require coercion", trace);
        }
        return coercionRequired;
    }
}

