/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveEmptyV5ValueSet
extends Transformation {
    public RemoveEmptyV5ValueSet() {
        this.mName = " Remove empty V5 Value Set without Group Body, when not referencing any data item.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 0 && node.getPropertyValue("refDataItem") == null) {
            status = true;
            this.traceNodeCondition(status, "The V5 Value Set has no data item ref and no group body, header or footer as child..", trace);
        }
        if (!status) {
            this.traceNodeCondition(status, "The V5 Value Set has child expression to be processed.", trace);
        }
        return status;
    }
}

