/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyValueSetDecoration;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.decoration.OLAPEmptyRowDecorationRules;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;

public final class RemoveV5ValueSetWithNoDataItemRefAndEmptyV5HeaderBodyFooter
extends Transformation {
    public RemoveV5ValueSetWithNoDataItemRefAndEmptyV5HeaderBodyFooter() {
        this.mName = "Remove V5 Value Set children that are not referencing data items.";
        this.mPassNumbers = new int[]{0, 3};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] children;
        RSAPIEdgeRowset nearestRowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        if (nearestRowset == null && node.getChildrenOfType(101051).length > 0) {
            IXQEQueryNode groupBody = node.getChildrenOfType(101051)[0];
            nearestRowset = (RSAPIEdgeRowset)groupBody.getPropertyValue("RSAPIEdgeRowset");
        }
        IXQEQueryNode outerEdgeGroup = node.getAncestorOfType(101050);
        outerEdgeGroup = outerEdgeGroup.getAncestorOfType(101050);
        V5ValueSet outerValueSet = (V5ValueSet)outerEdgeGroup.getChildrenOfType(101057)[0];
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        OLAPEmptyValueSetDecoration emptyValueSetDeco = (OLAPEmptyValueSetDecoration)nodeFactory.createNode(601018);
        emptyValueSetDeco.setRSAPIRowsetProperty(nearestRowset);
        outerValueSet.setPropertyValue("emptyValueSetDeco", emptyValueSetDeco);
        ArrayList<OLAPEmptyRowDecorationRules> emptyRowDecoRules = new ArrayList<OLAPEmptyRowDecorationRules>();
        int[] types = new int[]{101053, 101052, 101051};
        for (IXQEQueryNode child : children = node.getChildrenOfTypesOrdered(types)) {
            if (child.getChildrenOfType(101015).length > 0) continue;
            RSAPIEdgeRowset childRowset = (RSAPIEdgeRowset)child.getPropertyValue("RSAPIEdgeRowset");
            OLAPEmptyRowDecorationRules rules = (OLAPEmptyRowDecorationRules)environment.getRuleFactory().createRule(3);
            switch (child.getType()) {
                case 101053: {
                    rules.setEmptyRowType(OLAPEmptyRowDecorationRules.EmptyRowEnum.HEADER);
                    rules.setEmptyRowset(childRowset);
                    childRowset.setEmpty();
                    break;
                }
                case 101052: {
                    rules.setEmptyRowType(OLAPEmptyRowDecorationRules.EmptyRowEnum.FOOTER);
                    rules.setEmptyRowset(childRowset);
                    childRowset.setEmpty();
                    break;
                }
                case 101051: {
                    rules.setEmptyRowType(OLAPEmptyRowDecorationRules.EmptyRowEnum.GROUP_BODY);
                    rules.setEmptyRowset(nearestRowset);
                    nearestRowset.setEmpty();
                    break;
                }
                default: {
                    node.throwInternalError("");
                }
            }
            emptyRowDecoRules.add(rules);
            child.detach();
        }
        emptyValueSetDeco.setEmptyDecoRulesProperty(emptyRowDecoRules);
        if (node.getNumberChildrenOfTypes(types) == 0) {
            if (node.getParent().getNumberChildren() == 1) {
                node.getParent().detach();
            } else {
                node.detach();
            }
        }
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg, PlanningEnvironment environment) {
        IXQEQueryNode[] summaries;
        boolean status = false;
        IXQEQueryNode outerEdgeGroup = node.getAncestorOfType(101050);
        boolean bl = status = (outerEdgeGroup = outerEdgeGroup.getAncestorOfType(101050)) != null && outerEdgeGroup.getChildrenOfType(101057).length == 1;
        if (!status) {
            if (traceMsg != null) {
                traceMsg.append("The V5ValueSet does not have a single V5ValueSet above it.");
            }
            return status;
        }
        V5ValueSet outerValueSet = (V5ValueSet)outerEdgeGroup.getChildrenOfType(101057)[0];
        boolean bl2 = status = outerValueSet.getPropertyValue("emptyValueSetDeco") == null;
        if (!status) {
            if (traceMsg != null) {
                traceMsg.append("The V5ValueSet already has an empty valueset decoration.");
            }
            return status;
        }
        int[] types = new int[]{101053, 101052, 101051};
        boolean bl3 = status = node.getNumberChildrenOfTypes(types) != 0;
        if (!status) {
            if (traceMsg != null) {
                traceMsg.append("The V5ValueSet has no child of type V5GroupBody, V5Header, or V5Footer.");
            }
            return status;
        }
        if (node.getNumberChildrenOfCategory(1026) > 0) {
            if (traceMsg != null) {
                traceMsg.append("The V5ValueSet has at least one child of type CogMDXNest.");
            }
            return false;
        }
        status = ((V5ValueSet)node).isEmpty(true);
        if (!status) {
            if (traceMsg != null) {
                traceMsg.append("Either the V5ValueSet or its V5GroupBody refrences a dataItem.");
            }
            return status;
        }
        RSAPIEdgeRowset nearestRowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        if (nearestRowset == null && node.getChildrenOfType(101051).length > 0) {
            IXQEQueryNode groupBody = node.getChildrenOfType(101051)[0];
            nearestRowset = (RSAPIEdgeRowset)groupBody.getPropertyValue("RSAPIEdgeRowset");
        }
        boolean bl4 = status = nearestRowset != null;
        if (!status) {
            if (traceMsg != null) {
                traceMsg.append("The valueset's RSAPIEdgeRowsets has not been set yet.");
            }
            return status;
        }
        int[] typesWithChildRowset = new int[]{101053, 101052};
        for (IXQEQueryNode child : summaries = node.getChildrenOfTypes(typesWithChildRowset)) {
            RSAPIEdgeRowset childRowset = (RSAPIEdgeRowset)child.getPropertyValue("RSAPIEdgeRowset");
            boolean bl5 = status = childRowset != null;
            if (status) continue;
            if (traceMsg != null) {
                traceMsg.append("The RSAPIEdgeRowsets for a header or a footer has not been set yet.");
            }
            return status;
        }
        if (traceMsg != null) {
            traceMsg.append("The V5ValueSet does not project a daItem and the RSAPIEdgeRowsets have been set.");
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean status = RemoveV5ValueSetWithNoDataItemRefAndEmptyV5HeaderBodyFooter.nodeCondition(node, traceMsg, environment);
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }
}

