/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.List;

public class TransformMasterDetailQuery
extends Transformation {
    private static final String COMBINED = "Combined";
    private static final String NAME = "name";
    private static final String EDGE_NAME = "masterContext";
    private static final String MD_LINK_DATAITEM_SUFFIX = "_MDLINKDataItem";
    public static final String PROP_BOOLEAN_MD_QUERY_TRANSFORMED = "mdQueryTransformed";

    public TransformMasterDetailQuery() {
        this.mName = "Transform master-detail query to be executed all at once.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101059};
    }

    @Override
    public final void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TransformMasterDetailQuery.applyTransformation(node, environment, false);
    }

    public static void applyTransformation(IXQEQueryNode node, PlanningEnvironment environment, boolean relXtab) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MasterDetailLink link = ((V5MasterDetailLink)node).getMDProviderLink();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query masterQuery = querySet.getV5Query(link.getMasterQueryName());
        V5Selection masterSelection = masterQuery.getV5Selection();
        V5Query detailQuery = querySet.getV5Query(link.getDetailQueryName());
        V5QueryResultDefinition detailQrd = querySet.getQRD(link.getDetailQrdName());
        String masterRefDataItem = link.getMasterRefDataItem();
        V5QueryResultDefinition masterQrd = querySet.getQRD(link.getMasterQrdName());
        V5DataItem linkItem = masterSelection.getDataItemByRefName(masterRefDataItem);
        String newlinkItemName = null;
        if (!TransformMasterDetailQuery.findDataItemInQuery(detailQuery, linkItem)) {
            V5DataItem v5DataItemCopy = (V5DataItem)nodeFactory.deepCopyNode(linkItem);
            IXQEQueryNode[] nodes = detailQuery.getChildrenOfType(101009);
            if (nodes.length != 1) {
                detailQuery.throwInternalError("V5Query does not have exactly 1 selection");
            }
            if (TransformMasterDetailQuery.dataItemNameConflict(detailQuery, linkItem.getNameProperty())) {
                newlinkItemName = TransformMasterDetailQuery.generateDataItemName(linkItem.getNameProperty());
                while (TransformMasterDetailQuery.dataItemNameConflict(detailQuery, newlinkItemName)) {
                    newlinkItemName = TransformMasterDetailQuery.generateDataItemName(newlinkItemName);
                }
                v5DataItemCopy.setNameProperty(newlinkItemName);
            }
            nodes[0].addChild(v5DataItemCopy);
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getParent();
        V5QueryResultDefinition combinedQrd = TransformMasterDetailQuery.createCombinedQRD(detailQrd, nodeFactory, masterQrd, masterRefDataItem, newlinkItemName);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (IXQEQueryNode siblingNode : node.getParent().getChildrenOfType(101059)) {
            MasterDetailLink siblingLink = ((V5MasterDetailLink)siblingNode).getMDProviderLink();
            if (!siblingLink.getDetailQrdName().equals(link.getDetailQrdName())) continue;
            siblingNode.setPropertyValue(PROP_BOOLEAN_MD_QUERY_TRANSFORMED, true);
            if (parameterNames.contains(siblingLink.getName())) continue;
            parameterNames.add(siblingLink.getName());
        }
        TransformMasterDetailQuery.addMasterDetailWindowNodes(environment, parameterNames, qrd, detailQrd, combinedQrd, relXtab);
    }

    private static String generateDataItemName(String nameProperty) {
        if (nameProperty.contains(MD_LINK_DATAITEM_SUFFIX)) {
            if (nameProperty.endsWith(MD_LINK_DATAITEM_SUFFIX)) {
                return nameProperty + "_0";
            }
            int index = nameProperty.lastIndexOf(95);
            int currentNumber = Integer.parseInt(nameProperty.substring(index + 1));
            nameProperty = nameProperty.substring(0, index);
            return nameProperty + '_' + ++currentNumber;
        }
        return nameProperty + MD_LINK_DATAITEM_SUFFIX;
    }

    private static boolean dataItemNameConflict(V5Query detailQuery, String dataItemName) {
        V5Selection detailSelection = detailQuery.getV5Selection();
        V5DataItem dItem = detailSelection.getDataItemByRefName(dataItemName);
        return dItem != null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder msg = new StringBuilder();
        boolean status = TransformMasterDetailQuery.checkPassNodeCondition(node, environment, msg, false);
        this.traceNodeCondition(status, msg.toString(), trace);
        return status;
    }

    public static boolean checkPassNodeCondition(IXQEQueryNode node, PlanningEnvironment environment, StringBuilder msg, boolean relXtab) {
        String masterLinkInParentLink;
        V5QueryResultDefinition detailQrd;
        V5QuerySet querySet;
        boolean status = true;
        boolean bl = status = node.getBooleanPropertyValue(PROP_BOOLEAN_MD_QUERY_TRANSFORMED) == null;
        if (!status) {
            msg.append("The master-detail query already been transformed.");
            return status;
        }
        MasterDetailLink link = ((V5MasterDetailLink)node).getMDProviderLink();
        if (link == null) {
            node.throwInternalError("The link item should have been created by ProcessMasterDetailLinks");
        }
        if ((querySet = (V5QuerySet)node.getAncestorOfType(101002)) == null) {
            node.throwInternalError("The master detail link should be in a querySet");
        }
        boolean bl2 = status = !link.isParameterLink();
        if (!status) {
            msg.append("Cannot optimize parameter links yet");
            return status;
        }
        V5Query masterQuery = querySet.getV5Query(link.getMasterQueryName());
        V5Query detailQuery = querySet.getV5Query(link.getDetailQueryName());
        V5QueryResultDefinition masterQrd = querySet.getQRD(link.getMasterQrdName());
        status = TransformMasterDetailQuery.isValidMultiSectionCrosstab(link, masterQrd, masterQuery, environment);
        if (!status && !(status = TransformMasterDetailQuery.isMasterQRDOnlyProjectsLinkItem(masterQrd, link.getMasterRefDataItem()))) {
            msg.append("The master query doesn't project only the link item, ");
            return status;
        }
        status = TransformMasterDetailQuery.isMasterQRDProjectsSingleItemUnderGB(masterQrd);
        if (!status) {
            msg.append("This query can not be optimized, it projects more than 1 item in the group body");
            return status;
        }
        if (!relXtab) {
            status = TransformMasterDetailQuery.areLinkItemsOnSameCube(link, querySet);
            if (!status) {
                msg.append("The master and detail queries are not on the same OLAP datasource.");
                return status;
            }
            boolean bl3 = status = !TransformMasterDetailQuery.isDMRReportWithSeparateQueries(link, querySet);
            if (!status) {
                msg.append("The optimization cannot be applied on DMR models yet when the detail query does not project the link item.");
                return status;
            }
            boolean bl4 = status = !DecomposeScalarFunction.containsNotSupportedByOlapFunction(masterQuery);
            if (!status) {
                msg.append("The optimization cannot be applied, master query has scalar function.");
                return status;
            }
            boolean bl5 = status = !DecomposeScalarFunction.containsNotSupportedByOlapFunction(detailQuery);
            if (!status) {
                msg.append("The optimization cannot be applied, detail query has scalar function.");
                return status;
            }
        }
        if (masterQuery.isSingleQueryMasterDetail()) {
            boolean bl6 = status = !TransformMasterDetailQuery.doesQueryContainScopelessSummaryFilter(masterQuery);
            if (!status) {
                msg.append("A single query is used for the maaster and the detail and it contains a scopeless summary filter.");
                return status;
            }
        }
        boolean bl7 = status = (detailQrd = querySet.getQRD(link.getDetailQrdName())) != null;
        if (!status) {
            msg.append("Planning a detail query. No optimization is required.");
            return status;
        }
        status = TransformMasterDetailQuery.canDetailBecomeCrosstab(detailQrd);
        if (!status) {
            msg.append("The detail query cannot be transformed into a crosstab.");
            return status;
        }
        if (!masterQuery.isSingleQueryMasterDetail()) {
            int[] types = new int[]{101008, 101014};
            IXQEQueryNode[] filters = masterQuery.getChildrenOfTypes(types);
            boolean bl8 = status = filters.length == 0;
            if (!status) {
                msg.append("master-detail query optimization not supported: The master and detail QRDs have separate queries and the master query has detail filters or slicers.");
                return status;
            }
        }
        MasterDetailLink parentLink = link.getParentMDLink();
        String masterRef = link.getMasterRefDataItem();
        if (parentLink != null && masterRef.equals(masterLinkInParentLink = parentLink.getMasterRefDataItem()) && link.getMasterQueryNameOrig().equals(parentLink.getMasterQueryNameOrig())) {
            msg.append("Can't handle cascading m-d optimization for master already optimized case.");
            return false;
        }
        status = TransformMasterDetailQuery.doMDTransformation(link, querySet, environment, relXtab);
        if (!status) {
            msg.append("master-detail query optimization not enabled.");
            return status;
        }
        msg.append("The master-detail optimization will be applied.");
        return status;
    }

    private static boolean isValidMultiSectionCrosstab(MasterDetailLink link, V5QueryResultDefinition masterQrd, V5Query query, PlanningEnvironment environment) {
        if (!query.isSingleQueryMasterDetail()) {
            return false;
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        List<MasterDetailLink> siblingLinks = TransformMasterDetailQuery.getMDLinksForDetailQRD(masterQrd, link.getDetailQrdName(), parameterNames);
        if (parameterNames.size() == 1) {
            return false;
        }
        ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
        for (MasterDetailLink siblingLink : siblingLinks) {
            IHierarchy hierarchy = TransformMasterDetailQuery.getHierForDataItem(query, siblingLink.getDetailRefDataItem(), environment);
            if (hierarchy == null) {
                return false;
            }
            if (hierarchies.contains(hierarchy)) {
                return false;
            }
            hierarchies.add(hierarchy);
        }
        List<String> projection = TransformMasterDetailQuery.dataItemsProjectedByMasterQRD(masterQrd);
        if (projection.size() != siblingLinks.size()) {
            return false;
        }
        int index = 0;
        for (MasterDetailLink siblingLink : siblingLinks) {
            if (!siblingLink.getDetailRefDataItem().equals(projection.get(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static List<MasterDetailLink> getMDLinksForDetailQRD(V5QueryResultDefinition masterQrd, String detailQRDName, List<String> parameterNames) {
        ArrayList<MasterDetailLink> siblingLinks = new ArrayList<MasterDetailLink>();
        for (IXQEQueryNode masterDetailLink : masterQrd.getChildrenOfType(101059)) {
            MasterDetailLink siblingLink = ((V5MasterDetailLink)masterDetailLink).getMDProviderLink();
            if (!siblingLink.getDetailQrdName().equals(detailQRDName) || parameterNames.contains(siblingLink.getName())) continue;
            siblingLinks.add(siblingLink);
            parameterNames.add(siblingLink.getName());
        }
        return siblingLinks;
    }

    private static boolean isMasterQRDOnlyProjectsLinkItem(V5QueryResultDefinition masterQrd, String masterRefDataItem) {
        List<String> projection = TransformMasterDetailQuery.dataItemsProjectedByMasterQRD(masterQrd);
        if (projection.size() != 1) {
            return false;
        }
        return projection.get(0).equals(masterRefDataItem);
    }

    private static List<String> dataItemsProjectedByMasterQRD(V5QueryResultDefinition masterQrd) {
        ArrayList<String> projectedItemNames = new ArrayList<String>();
        int[] types = new int[]{101057, 101015};
        List<IXQEQueryNode> valueSetsAndRefDataItems = masterQrd.getDescendantsOfTypesOrdered(types, false);
        for (IXQEQueryNode proj : valueSetsAndRefDataItems) {
            if (proj.getType() == 101057) {
                V5ValueSet vs = (V5ValueSet)proj;
                String refDataItem = vs.getRefDataItemProperty();
                if (refDataItem == null) continue;
                projectedItemNames.add(refDataItem);
                continue;
            }
            if (proj.getType() != 101015) continue;
            projectedItemNames.add(((V5DataItemRef)proj).getDataItemRefProperty());
        }
        return projectedItemNames;
    }

    public static boolean doesQueryContainScopelessSummaryFilter(V5Query masterQuery) {
        IXQEQueryNode[] filters;
        for (IXQEQueryNode filter : filters = masterQuery.getChildrenOfType(101011)) {
            if (filter.getNumberChildrenOfType(101012) != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean areLinkItemsOnSameCube(MasterDetailLink link, V5QuerySet querySet) {
        V5Query detailQuery;
        ICube masterCube = TransformMasterDetailQuery.getCubeForDataItem(querySet.getV5Query(link.getMasterQueryName()), link.getMasterRefDataItem());
        if (masterCube == null) {
            return false;
        }
        ICube detailCube = null;
        String detailRefDataItem = null;
        if (!link.isParameterLink()) {
            detailRefDataItem = link.getDetailRefDataItem();
        }
        if ((detailQuery = querySet.getV5Query(link.getDetailQueryName())) == null) {
            detailQuery = querySet.getV5Query(link.getDetailQueryNameOrig());
        }
        if ((detailCube = TransformMasterDetailQuery.getCubeForDataItem(detailQuery, detailRefDataItem)) == null) {
            return false;
        }
        boolean status = detailCube.equals(masterCube);
        return status;
    }

    private static boolean isDMRReportWithSeparateQueries(MasterDetailLink link, V5QuerySet querySet) {
        ICube masterCube = TransformMasterDetailQuery.getCubeForDataItem(querySet.getV5Query(link.getMasterQueryName()), link.getMasterRefDataItem());
        if (masterCube == null) {
            return false;
        }
        if (masterCube.getModelDataSource().isRelational()) {
            String masterRefDataItem;
            V5DataItem linkItem;
            V5Query masterQuery = querySet.getV5Query(link.getMasterQueryName());
            V5Selection masterSelection = masterQuery.getV5Selection();
            V5Query detailQuery = querySet.getV5Query(link.getDetailQueryName());
            return !TransformMasterDetailQuery.findDataItemInQuery(detailQuery, linkItem = masterSelection.getDataItemByRefName(masterRefDataItem = link.getMasterRefDataItem()));
        }
        return false;
    }

    private static ICube getCubeForDataItem(V5Query query, String refDataItem) {
        List<IXQEQueryNode> boundItems;
        if (refDataItem != null) {
            V5Selection selection = query.getV5Selection();
            V5DataItem linkItem = selection.getDataItemByRefName(refDataItem);
            if (linkItem == null) {
                return null;
            }
            boundItems = linkItem.getDescendantsOfCategory(201115, false);
        } else {
            boundItems = query.getDescendantsOfCategory(201115, false);
        }
        ICube cube = null;
        for (IXQEQueryNode boundItem : boundItems) {
            V5BoundMultiPartIdentifier item = (V5BoundMultiPartIdentifier)boundItem;
            MDXHierInfo hierInfo = item.getHierarchyInfo();
            if (hierInfo == null || hierInfo.getNumProjectedHierarchies() < 1) continue;
            cube = hierInfo.getProjectedHierarchy(0).getDimension().getCube();
            break;
        }
        return cube;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IHierarchy getHierForDataItem(V5Query query, String refDataItem, PlanningEnvironment environment) {
        IXQEQueryNode[] boundItems;
        int[] types = new int[]{201116, 201117};
        if (refDataItem != null) {
            V5Selection selection = query.getV5Selection();
            V5DataItem linkItem = selection.getDataItemByRefName(refDataItem);
            if (linkItem == null) {
                linkItem = selection.getDataItemByRefNameFromV5Parameter(refDataItem);
            }
            if (linkItem == null) return null;
            boundItems = linkItem.getDescendantsOfTypes(types, false);
        } else {
            boundItems = query.getDescendantsOfTypes(types, false);
        }
        IHierarchy hierarchy = null;
        IXQEQueryNode[] iXQEQueryNodeArray = boundItems;
        int n = iXQEQueryNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXQEQueryNode boundItem = iXQEQueryNodeArray[n2];
            MDXHierInfo hierInfo = null;
            switch (boundItem.getType()) {
                case 201116: {
                    V5BoundModelIdentifier itemModel = (V5BoundModelIdentifier)boundItem;
                    hierInfo = itemModel.getHierarchyInfo();
                    break;
                }
                case 201117: {
                    V5BoundMemberUniqueName itemMUN = (V5BoundMemberUniqueName)boundItem;
                    hierInfo = itemMUN.getHierarchyInfo();
                    break;
                }
            }
            if (hierInfo != null && hierInfo.getNumProjectedHierarchies() == 1) {
                return hierInfo.getProjectedHierarchy(0);
            }
            ++n2;
        }
        return hierarchy;
    }

    public static boolean canDetailBecomeCrosstab(V5QueryResultDefinition detailQrd) {
        boolean status = true;
        int[] types = new int[]{101051, 101052, 101053};
        boolean bl = status = detailQrd.getDescendantsOfTypes(types, false).length == 0;
        if (!status) {
            return status;
        }
        List<IXQEQueryNode> descValueSets = detailQrd.getDescendantsOfTypeOrdered(101057, false);
        List<V5ValueSet> valueSets = CollectionCast.downcast(descValueSets, IXQEQueryNode.class, V5ValueSet.class);
        for (V5ValueSet valueSet : valueSets) {
            status = valueSet.getRefDataItemProperty() != null;
            if (status) continue;
            return status;
        }
        return status;
    }

    private static void addMasterDetailWindowNodes(PlanningEnvironment environment, List<String> parameterNames, V5QueryResultDefinition masterQrd, V5QueryResultDefinition detailQrd, V5QueryResultDefinition combinedQrd, boolean relXtab) {
        V5MasterDetailWindow mdwMaster = null;
        int masterId = -1;
        if (!relXtab) {
            mdwMaster = (V5MasterDetailWindow)environment.getNodeFactory().createNode(601026);
            masterQrd.addChild(mdwMaster);
            masterId = mdwMaster.getId();
        }
        V5MasterDetailWindow mdwDetail = (V5MasterDetailWindow)environment.getNodeFactory().createNode(601026);
        mdwDetail.setMasterDetailParameterName(parameterNames);
        detailQrd.addChild(mdwDetail);
        V5MasterDetailWindow mdwCombined = (V5MasterDetailWindow)environment.getNodeFactory().createNode(601026);
        combinedQrd.addChild(mdwCombined);
        mdwCombined.setMasterDetailParameterName(parameterNames);
        mdwDetail.setMasterDetailWindowNodeIDDetail(mdwDetail.getId());
        mdwDetail.setMasterDetailWindowNodeIDMaster(masterId);
        mdwDetail.setMasterDetailWindowNodeIDCombined(mdwCombined.getId());
        if (!relXtab) {
            mdwMaster.setMasterDetailWindowNodeIDDetail(mdwDetail.getId());
            mdwMaster.setMasterDetailWindowNodeIDMaster(masterId);
            mdwMaster.setMasterDetailWindowNodeIDCombined(mdwCombined.getId());
        }
        mdwCombined.setMasterDetailWindowNodeIDDetail(mdwDetail.getId());
        mdwCombined.setMasterDetailWindowNodeIDMaster(masterId);
        mdwCombined.setMasterDetailWindowNodeIDCombined(mdwCombined.getId());
    }

    public static boolean findDataItemInQuery(V5Query detailQuery, V5DataItem dataItem) {
        boolean dataItemInDetailQuery = false;
        V5Selection detailSelection = detailQuery.getV5Selection();
        V5DataItem dItem = detailSelection.getDataItemByRefName(dataItem.getNameProperty());
        if (dItem != null && dItem.isSameExpression(dataItem, false)) {
            dataItemInDetailQuery = true;
        }
        return dataItemInDetailQuery;
    }

    public static V5QueryResultDefinition createCombinedQRD(V5QueryResultDefinition detailQrd, XQENodeFactory nodeFactory, V5QueryResultDefinition masterQrd, String originalDataItemName, String newDataItemName) {
        V5QueryResultDefinition newQrd = (V5QueryResultDefinition)nodeFactory.deepCopyNode(detailQrd);
        newQrd.setPropertyValue(NAME, detailQrd.getName() + COMBINED);
        V5Edge masterEdge = (V5Edge)masterQrd.getChildrenOfType(101049)[0];
        V5Edge v5Edge = (V5Edge)nodeFactory.deepCopyNode(masterEdge);
        if (newDataItemName != null) {
            IXQEQueryNode[] valueSets;
            IXQEQueryNode[] refs;
            for (IXQEQueryNode ref : refs = v5Edge.getDescendantsOfType(101015, false)) {
                if (!((V5DataItemRef)ref).getDataItemRefProperty().equals(originalDataItemName)) continue;
                ref.setPropertyValue("refDataItem", newDataItemName);
            }
            for (IXQEQueryNode ref : valueSets = v5Edge.getDescendantsOfType(101057, false)) {
                if (((V5ValueSet)ref).getRefDataItemProperty() == null || !((V5ValueSet)ref).getRefDataItemProperty().equals(originalDataItemName)) continue;
                ((V5ValueSet)ref).setRefDataItemProperty(newDataItemName);
            }
        }
        v5Edge.setPropertyValue(NAME, EDGE_NAME);
        IXQEQueryNode[] edges = detailQrd.getChildrenOfTypeOrdered(101049);
        int edgeId = ((V5Edge)edges[edges.length - 1]).getEdgeID();
        v5Edge.setEdgeID(edgeId + 1);
        newQrd.addChild(v5Edge);
        int[] types = new int[]{101051};
        for (IXQEQueryNode node : v5Edge.getDescendantsOfTypes(types, false)) {
            IXQEQueryNode[] dataItemRefs = node.getDescendantsOfType(101015, false);
            if (dataItemRefs.length == 1) {
                String dataItemRefProperty = ((V5DataItemRef)dataItemRefs[0]).getDataItemRefProperty();
                V5ValueSet vs = (V5ValueSet)node.getAncestorOfType(101057);
                vs.setRefDataItemProperty(dataItemRefProperty);
                node.detach();
                continue;
            }
            node.getParent().getParent().detach();
        }
        int[] types2 = new int[]{101053, 101052};
        for (IXQEQueryNode node : v5Edge.getDescendantsOfTypes(types2, false)) {
            node.detach();
        }
        detailQrd.getParent().addChild(newQrd);
        return newQrd;
    }

    private static boolean doMDTransformation(MasterDetailLink link, V5QuerySet querySet, PlanningEnvironment environment, boolean relXtab) {
        V5Query masterQuery = querySet.getV5Query(link.getMasterQueryName());
        V5QueryResultDefinition masterQrd = querySet.getQRD(link.getMasterQrdName());
        Governors governors = null;
        Object govProperty = masterQrd.getPropertyValue("governors");
        governors = govProperty != null ? (Governors)govProperty : (Governors)masterQuery.getPropertyValue("governors");
        if (governors == null) {
            masterQrd.throwInternalError("Could not find query governor");
        }
        if (governors.getOptimizeMasterDetailForAllRows() == Governors.OptimizeMasterDetailForAllRows.ALWAYS) {
            return true;
        }
        if (governors.getOptimizeMasterDetailForAllRows() == Governors.OptimizeMasterDetailForAllRows.NEVER) {
            return false;
        }
        Governors.ExecutionOptimization optimization = governors.getExecutionOptimization();
        if (relXtab) {
            return optimization.equals((Object)Governors.ExecutionOptimization.ALLROWS);
        }
        ICube masterCube = TransformMasterDetailQuery.getCubeForDataItem(masterQuery, link.getMasterRefDataItem());
        if (masterCube == null) {
            return false;
        }
        IModelDataSource modelDS = masterCube.getModelDataSource();
        IDataSource dataSource = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getOrAddDataSource(modelDS);
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        if (capabilities.isSupported("v5.master-detail.transform") && optimization.equals((Object)Governors.ExecutionOptimization.ALLROWS)) {
            return true;
        }
        return capabilities.isSupported("v5.master-detail.transform.allRowsOrNot");
    }

    public static boolean isMasterQRDProjectsSingleItemUnderGB(V5QueryResultDefinition masterQrd) {
        V5Edge masterEdge = (V5Edge)masterQrd.getChildrenOfType(101049)[0];
        for (IXQEQueryNode node : masterEdge.getDescendantsOfType(101051, false)) {
            IXQEQueryNode[] dataItemRefs = node.getDescendantsOfType(101015, false);
            if (dataItemRefs.length <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isMasterQueryOnlyProjectsLinkItem(V5Query masterQuery, String linkItemName) {
        int numProjectedItem = 0;
        V5Selection masterSelection = masterQuery.getV5Selection();
        V5DataItem linkItem = masterSelection.getDataItemByRefName(linkItemName);
        if (linkItem == null || !linkItem.getIsProjected()) {
            return false;
        }
        for (IXQEQueryNode v5DataItem : masterSelection.getChildren()) {
            if (((V5DataItem)v5DataItem).getIsProjected()) {
                ++numProjectedItem;
            }
            if (numProjectedItem > 1) break;
        }
        return numProjectedItem == 1;
    }
}

