/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;

public final class CleanGroupBodySortOnReportSummayOrFact
extends Transformation {
    public CleanGroupBodySortOnReportSummayOrFact() {
        this.mName = "Clean Group Body and sort defined on report summary or fact.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] groupBodys;
        IXQEQueryNode edgeGroup;
        String refDataItemName;
        IXQEQueryNode[] sorts;
        for (IXQEQueryNode sort : sorts = node.getChildrenOfType(101056)) {
            sort.detach();
        }
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        IXQEQueryNode rsapiNode = v5QRD.getAncestorOfType(401005);
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        V5Query v5Query = v5QRD.getV5Query();
        V5Selection selection = v5Query.getV5Selection();
        V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName = ((V5ValueSet)node).getRefDataItemProperty());
        boolean isReportSummary = TabStreamUtil.getReportSummaryDetailEdgeGroup((V5ValueSet)node, dataItem, null) != null;
        boolean hasParentGroup = false;
        if (isReportSummary && (edgeGroup = node.getAncestorOfType(101050)) != null) {
            hasParentGroup = (edgeGroup = edgeGroup.getAncestorOfType(101050)) != null;
        }
        for (IXQEQueryNode aBody : groupBodys = node.getChildrenOfType(101051)) {
            IXQEQueryNode[] refItems = aBody.getChildrenOfType(101015);
            if (refItems.length == 0) {
                aBody.detach();
                continue;
            }
            if (isReportSummary && hasParentGroup) {
                aBody.setPropertyValue("wrapTo", Boolean.TRUE);
                continue;
            }
            for (IXQEQueryNode aItem : refItems) {
                V5DataItemRef ref = (V5DataItemRef)aItem;
                String refName = ref.getDataItemRefProperty();
                RSAPIDataItem item = TabStreamUtil.getRSAPIDataItemByName(rsapiNode, (String)edge.getPropertyValue("name"), ((V5ValueSet)node).getNameProperty(), refName);
                item.setNotApplicableGroupbody();
            }
            aBody.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String refDataItemName;
        V5DataItem dataItem;
        V5Selection selection;
        V5Query v5Query;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (v5QRD != null && v5QRD.getPropertyValue("tabstreamDefinition") != null && (v5Query = v5QRD.getV5Query()) != null && (selection = v5Query.getV5Selection()) != null && (TabStreamUtil.getReportSummaryDetailEdgeGroup((V5ValueSet)node, dataItem = selection.getDataItemByRefName(refDataItemName = ((V5ValueSet)node).getRefDataItemProperty()), null) != null || TabStreamUtil.isFactItem(dataItem))) {
            IXQEQueryNode[] sorts = node.getChildrenOfType(101056);
            boolean bl = status = sorts.length > 0;
            if (!status) {
                IXQEQueryNode[] groupBodys;
                for (IXQEQueryNode gB : groupBodys = node.getChildrenOfType(101051)) {
                    if (gB.getPropertyValue("wrapTo") != null) continue;
                    status = true;
                    break;
                }
            }
        }
        if (status) {
            this.traceNodeCondition(status, "need to clean group body and sort.", trace);
        } else {
            this.traceNodeCondition(status, "no group body and sort to be cleaned.", trace);
        }
        return status;
    }
}

