/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;

public final class CreateCubeWrapperForRelationalCrosstab
extends Transformation {
    public CreateCubeWrapperForRelationalCrosstab() {
        this.mName = "Wrap V5DataItem in Relational CrossTab to level or measure.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        V5Source src = v5Query.getV5Source();
        CubeWrapper theCubeWrapper = TabStreamUtil.createCubeWrapperAndSetRelDatasource(environment, null, null, src, querySet, node.getGovernors());
        src.detachChildren();
        theCubeWrapper.setTabularResultSetName((String)v5QRD.getPropertyValue("tabstreamDefinition"));
        src.setPropertyValue("needTabularStream", theCubeWrapper);
        RSAPIDataset dataset = (RSAPIDataset)node.getAncestorOfType(401005);
        dataset.setForXtabRelational(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Object tabDef = node.getPropertyValue("tabstreamDefinition");
        if (tabDef != null) {
            V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
            V5Query v5Query = v5QRD.getV5Query();
            V5Source src = v5Query.getV5Source();
            Object cube = src.getPropertyValue("needTabularStream");
            boolean bl = status = !(cube instanceof CubeWrapper);
        }
        if (status) {
            this.traceNodeCondition(status, "need to create CubeWrapper for relatioanl crosstab.", trace);
        } else {
            this.traceNodeCondition(status, "don't create CubeWrapper for relatioanl crosstab.", trace);
        }
        return status;
    }
}

