/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamExternalAggrUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class CreateExternalRollUp
extends Transformation {
    public CreateExternalRollUp() {
        this.mName = "Create external rollUp for report summary.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("wrapTo");
        V5ValueSet valueSet = (V5ValueSet)node;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, v5QRD);
        boolean[] bIsWithinSet = new boolean[]{false, false, false};
        if (!this.isReportSummary(env, valueSet, bIsWithinSet) || bIsWithinSet[1]) {
            return;
        }
        IXQEQueryNode[] edges = v5QRD.getChildrenOfType(101049);
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        V5Edge reportMeasureEdge = CreateExternalRollUp.getReportMeasureEdge(env, v5QRD);
        LinkedList<IXQEQueryNode> stack = new LinkedList<IXQEQueryNode>();
        int pos = 0;
        V5Edge[] twoEdges = new V5Edge[]{edge, reportMeasureEdge};
        this.generateRollUps(env, edges, pos, stack, twoEdges, node, bIsWithinSet);
    }

    public static V5Edge getReportMeasureEdge(TabStreamUtil.WrapCommonObjects env, V5QueryResultDefinition v5QRD) {
        IXQEQueryNode[] edges;
        V5Edge reportMeasureEdge = null;
        for (IXQEQueryNode edge : edges = v5QRD.getChildrenOfType(101049)) {
            V5ValueSet valueSet;
            String refDataItem;
            V5DataItem v5DataItem;
            IXQEQueryNode[] v5Grps = edge.getDescendantsOfType(101050, false);
            if (v5Grps.length != 1 || !TabStreamUtil.isFactItem(v5DataItem = env.mSelection.getDataItemByRefName(refDataItem = (valueSet = (V5ValueSet)v5Grps[0].getFirstChildByType(101057)).getRefDataItemProperty())) || reportMeasureEdge != null && ((V5Edge)edge).getEdgeID() <= reportMeasureEdge.getEdgeID()) continue;
            reportMeasureEdge = (V5Edge)edge;
        }
        return reportMeasureEdge;
    }

    protected boolean isReportSummary(TabStreamUtil.WrapCommonObjects env, V5ValueSet valueSet, boolean[] bIsWithinSet) {
        IXQEQueryNode[] withins;
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(valueSet.getRefDataItemProperty());
        if (bIsWithinSet != null && (withins = v5DataItem.getDescendantsOfType(201039, false)).length == 1 && withins[0].getPropertyValue("scope") != null) {
            bIsWithinSet[2] = true;
        }
        return TabStreamUtil.getReportSummaryDetailEdgeGroup(valueSet, v5DataItem, bIsWithinSet) != null;
    }

    protected IXQEQueryNode getReportSummary(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode valueSet, boolean[] withinSet) {
        if (this.isReportSummary(env, (V5ValueSet)valueSet, withinSet)) {
            return valueSet;
        }
        IXQEQueryNode grp = valueSet.getParent();
        IXQEQueryNode[] groups = grp.getAncestorsOfType(101050);
        for (int i = groups.length - 1; i >= 0; --i) {
            IXQEQueryNode vs = groups[i].getFirstChildByType(101057);
            if (!this.isReportSummary(env, (V5ValueSet)vs, withinSet)) continue;
            return vs;
        }
        return null;
    }

    protected V5DataItemToLevelWrapper getLevelWrapper(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode valueSet, boolean include) {
        V5ValueSet vs = (V5ValueSet)valueSet;
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(vs.getRefDataItemProperty());
        IXQEQueryNode grpForSum = TabStreamUtil.getReportSummaryDetailEdgeGroup(vs, v5DataItem, null);
        if (grpForSum == null && !TabStreamUtil.isFactItem(v5DataItem)) {
            HashSet<IMetadata> metas = new HashSet<IMetadata>();
            TabStreamUtil.getWrapperObject(v5DataItem, metas);
            if (metas.size() == 1) {
                return (V5DataItemToLevelWrapper)metas.iterator().next();
            }
            return null;
        }
        ArrayList<IXQEQueryNode> allGroups = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode grp = vs.getParent();
        IXQEQueryNode[] groups = grp.getAncestorsOfType(101050);
        if (include && grpForSum != null) {
            allGroups.add(grpForSum);
        }
        allGroups.addAll(Arrays.asList(groups));
        for (IXQEQueryNode aGrp : allGroups) {
            vs = (V5ValueSet)aGrp.getFirstChildByType(101057);
            if (TabStreamUtil.getReportSummaryDetailEdgeGroup(vs, v5DataItem = env.mSelection.getDataItemByRefName(vs.getRefDataItemProperty()), null) != null || TabStreamUtil.isFactItem(v5DataItem)) continue;
            HashSet<IMetadata> metas = new HashSet<IMetadata>();
            TabStreamUtil.getWrapperObject(v5DataItem, metas);
            if (metas.size() == 1) {
                return (V5DataItemToLevelWrapper)metas.iterator().next();
            }
            return null;
        }
        return null;
    }

    protected V5DataItemToLevelWrapper getDetailLevelWrapper(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode grp, IXQEQueryNode leaf) {
        V5ValueSet vs = (V5ValueSet)leaf.getFirstChildByType(101057);
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(vs.getRefDataItemProperty());
        String detail = v5DataItem.getDetailProperty();
        if (!detail.equals("true") && !detail.equals("automatic_true")) {
            return null;
        }
        if (TabStreamUtil.getReportSummaryDetailEdgeGroup(vs, v5DataItem, null) != null) {
            return null;
        }
        if (TabStreamUtil.isFactItem(v5DataItem)) {
            if (leaf.equals(grp)) {
                return null;
            }
            return this.getDetailLevelWrapper(env, grp, leaf.getAncestorOfType(101050));
        }
        HashSet<IMetadata> metas = new HashSet<IMetadata>();
        TabStreamUtil.getWrapperObject(v5DataItem, metas);
        if (metas.size() == 1) {
            return (V5DataItemToLevelWrapper)metas.iterator().next();
        }
        return null;
    }

    protected V5DataItemToLevelWrapper getDetailLevelWrapper(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode valueSet, boolean[] bret) {
        V5ValueSet vs = (V5ValueSet)valueSet;
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(vs.getRefDataItemProperty());
        IXQEQueryNode grpForSum = TabStreamUtil.getReportSummaryDetailEdgeGroup(vs, v5DataItem, null);
        if (grpForSum == null) {
            bret[0] = true;
            return null;
        }
        IXQEQueryNode[] groups = grpForSum.getDescendantsOfType(101050, true);
        ArrayList<IXQEQueryNode> leafs = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode n : groups) {
            IXQEQueryNode[] tmp = n.getChildrenOfType(101050);
            if (tmp.length != 0) continue;
            leafs.add(n);
        }
        V5DataItemToLevelWrapper ret = null;
        for (IXQEQueryNode l : leafs) {
            V5DataItemToLevelWrapper lvl = this.getDetailLevelWrapper(env, grpForSum, l);
            if (lvl == null) continue;
            if (ret == null) {
                ret = lvl;
                continue;
            }
            bret[0] = true;
            return null;
        }
        return ret;
    }

    protected IXQEQueryNode getMeasure(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode valueSet, boolean[] b) {
        V5ValueSet vs = (V5ValueSet)valueSet;
        IXQEQueryNode rt = null;
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(vs.getRefDataItemProperty());
        if (!this.isReportSummary(env, vs, null) && TabStreamUtil.isFactItem(v5DataItem)) {
            rt = valueSet;
        }
        IXQEQueryNode grp = valueSet.getParent();
        IXQEQueryNode[] groups = grp.getAncestorsOfType(101050);
        for (int i = groups.length - 1; i >= 0; --i) {
            vs = (V5ValueSet)groups[i].getFirstChildByType(101057);
            v5DataItem = env.mSelection.getDataItemByRefName(vs.getRefDataItemProperty());
            if (this.isReportSummary(env, vs, null) || !TabStreamUtil.isFactItem(v5DataItem)) continue;
            if (rt == null) {
                rt = vs;
                continue;
            }
            b[0] = true;
            return null;
        }
        return rt;
    }

    protected void generateRollUps(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode[] edges, int pos, LinkedList<IXQEQueryNode> stack, V5Edge[] two, IXQEQueryNode reportSummary, boolean[] flags) {
        if (pos == edges.length - 1) {
            ArrayList<IXQEQueryNode> nodes = this.getLeafNodes(edges[pos], two[0], reportSummary);
            for (IXQEQueryNode node : nodes) {
                stack.addLast(node);
                this.createRollUp(env, stack, reportSummary, two[1], flags);
                stack.removeLast();
            }
        } else {
            ArrayList<IXQEQueryNode> nodes = this.getLeafNodes(edges[pos], two[0], reportSummary);
            for (IXQEQueryNode node : nodes) {
                stack.addLast(node);
                this.generateRollUps(env, edges, pos + 1, stack, two, reportSummary, flags);
                stack.removeLast();
            }
        }
    }

    protected ArrayList<IXQEQueryNode> getLeafNodes(IXQEQueryNode edge, V5Edge currentEdge, IXQEQueryNode reportSummary) {
        ArrayList<IXQEQueryNode> leaf = new ArrayList<IXQEQueryNode>();
        if (edge.equals(currentEdge)) {
            IXQEQueryNode parentGrp = reportSummary.getParent();
            IXQEQueryNode[] childrenGrp = parentGrp.getChildrenOfType(101050);
            if (childrenGrp.length > 0) {
                for (IXQEQueryNode grp : childrenGrp) {
                    leaf.add(grp.getFirstChildByType(101057));
                }
            } else {
                leaf.add(reportSummary);
            }
        } else {
            List<IXQEQueryNode> v5Grps = edge.getDescendantsOfTypeOrdered(101050, false);
            for (IXQEQueryNode grp : v5Grps) {
                IXQEQueryNode v5GrpTmp = grp.getFirstChildByType(101050);
                if (v5GrpTmp != null) continue;
                leaf.add(grp.getFirstChildByType(101057));
            }
        }
        return leaf;
    }

    protected int getSolveOrder(TabStreamUtil.WrapCommonObjects env, V5ValueSet valueSet) {
        String itemName = valueSet.getRefDataItemProperty();
        V5DataItem item = env.mSelection.getDataItemByRefName(itemName);
        Integer s = item.getSolveOrderProperty();
        if (s != null) {
            return s;
        }
        return 0;
    }

    protected int getEdgeId(V5ValueSet valueSet) {
        V5Edge edge = (V5Edge)valueSet.getAncestorOfType(101049);
        return edge.getEdgeID();
    }

    protected boolean isReportMeasure(V5ValueSet valueSet, V5Edge reportMeasureEdge) {
        V5Edge edge = (V5Edge)valueSet.getAncestorOfType(101049);
        return edge.equals(reportMeasureEdge);
    }

    protected V5ValueSet getSummaryNode(TabStreamUtil.WrapCommonObjects env, LinkedList<IXQEQueryNode> stack, boolean[] flags, IXQEQueryNode reportSummary, boolean[] otherFlags, V5ValueSet[] otherSum) {
        for (IXQEQueryNode leaf : stack) {
            boolean[] withinSet;
            V5ValueSet sum = (V5ValueSet)this.getReportSummary(env, leaf, withinSet = new boolean[]{false, false, false});
            if (sum == null || reportSummary.equals(sum)) continue;
            if (otherSum[0] != null) {
                return null;
            }
            otherSum[0] = sum;
            System.arraycopy(withinSet, 0, otherFlags, 0, withinSet.length);
        }
        if (!(otherSum[0] != null && otherFlags[2] || flags[0] || flags[2])) {
            return null;
        }
        V5ValueSet summaryNode = null;
        int summaryEdgeId = -1;
        for (IXQEQueryNode leaf : stack) {
            boolean[] withinSet;
            V5ValueSet sum = (V5ValueSet)this.getReportSummary(env, leaf, withinSet = new boolean[]{false, false, false});
            if (sum == null) continue;
            if (summaryNode == null) {
                summaryNode = sum;
                summaryEdgeId = this.getEdgeId(sum);
                continue;
            }
            boolean bUpdate = false;
            if (!otherFlags[2] && !flags[2]) {
                if (this.getSolveOrder(env, summaryNode) < this.getSolveOrder(env, sum) || this.getSolveOrder(env, summaryNode) == this.getSolveOrder(env, sum) && summaryEdgeId < this.getEdgeId(sum)) {
                    bUpdate = true;
                }
            } else if (this.getSolveOrder(env, summaryNode) > this.getSolveOrder(env, sum) || this.getSolveOrder(env, summaryNode) == this.getSolveOrder(env, sum) && summaryEdgeId > this.getEdgeId(sum)) {
                bUpdate = true;
            }
            if (!bUpdate) continue;
            summaryNode = sum;
            summaryEdgeId = this.getEdgeId(sum);
        }
        return summaryNode;
    }

    protected void createRollUp(TabStreamUtil.WrapCommonObjects env, LinkedList<IXQEQueryNode> stack, IXQEQueryNode reportSummary, V5Edge reportMeasureEdge, boolean[] flags) {
        boolean[] otherFlags = new boolean[]{false, false, false};
        V5ValueSet[] otherSum = new V5ValueSet[]{null};
        V5ValueSet summaryNode = this.getSummaryNode(env, stack, flags, reportSummary, otherFlags, otherSum);
        if (summaryNode == null || !summaryNode.equals(reportSummary)) {
            return;
        }
        V5ValueSet measureNode = null;
        for (IXQEQueryNode node : stack) {
            boolean[] b = new boolean[]{false};
            V5ValueSet measure = (V5ValueSet)this.getMeasure(env, node, b);
            if (b[0]) {
                return;
            }
            if (measure == null) continue;
            if (measureNode == null || this.isReportMeasure(measureNode, reportMeasureEdge)) {
                measureNode = measure;
                continue;
            }
            if (this.isReportMeasure(measure, reportMeasureEdge)) continue;
            return;
        }
        if (measureNode == null) {
            return;
        }
        boolean[] forceExtAggr = new boolean[]{false};
        V5DataItem measureItem = env.mSelection.getDataItemByRefName(measureNode.getRefDataItemProperty());
        if (!(flags[2] || otherSum[0] != null && otherFlags[2] || TabStreamExternalAggrUtil.measureNeedExtAggr(env, measureItem, forceExtAggr))) {
            return;
        }
        if (forceExtAggr[0]) {
            TabStreamExternalAggrUtil.markExternalAggregate(measureItem);
        }
        HashSet<IMetadata> measureObjs = new HashSet<IMetadata>();
        TabStreamUtil.getWrapperObject(measureItem, measureObjs);
        for (IMetadata meta : measureObjs) {
            V5DataItemToMeasureWrapper measureObj = (V5DataItemToMeasureWrapper)meta;
            AggregateTypeEnum rollType = measureObj.getRegularAggregate();
            boolean isExplicitRollUp = rollType != AggregateTypeEnum.CALCULATED;
            ArrayList<ILevel> scope = this.getScope(env, stack, (V5ValueSet)reportSummary, flags, otherSum[0], otherFlags, isExplicitRollUp);
            if (scope == null || measureObj.containsScope(scope)) continue;
            V5DataItem orgItem = TabStreamUtil.getOriginalMeasureV5DataItem(env, measureObj, measureItem);
            String columnPos = TabStreamUtil.addExternalRollUp(env, scope, orgItem);
            measureObj.addScope(scope, columnPos);
        }
    }

    protected ArrayList<ILevel> getScope(TabStreamUtil.WrapCommonObjects env, LinkedList<IXQEQueryNode> stack, V5ValueSet reportSummary, boolean[] flags, V5ValueSet otherSummary, boolean[] otherFlags, boolean isExplicitMeasureRollUp) {
        ArrayList<ILevel> scope = null;
        if (otherSummary == null) {
            if (!flags[2]) {
                if (isExplicitMeasureRollUp || !flags[0]) {
                    return null;
                }
                scope = this.getMeasureLevelScope(env, stack, false);
            } else {
                scope = flags[0] && !isExplicitMeasureRollUp ? this.getMeasureLevelScope(env, stack, false) : this.getMeasureLevelScope(env, stack, true);
            }
            if (this.containsAllLowestLevels(scope)) {
                return null;
            }
            return scope;
        }
        if (!flags[2] && !otherFlags[2]) {
            if (isExplicitMeasureRollUp || !flags[0]) {
                return null;
            }
            scope = this.getMeasureLevelScope(env, stack, false);
            if (this.containsAllLowestLevels(scope)) {
                return null;
            }
            return scope;
        }
        if (flags[2] && otherFlags[2]) {
            scope = isExplicitMeasureRollUp ? this.getMeasureLevelScope(env, stack, true) : (!flags[0] && !otherFlags[0] ? this.getMeasureLevelScope(env, stack, true) : (flags[0] && otherFlags[0] ? this.getMeasureLevelScope(env, stack, false) : (!flags[0] ? this.getMeasureLevelScopeIncludeOne(env, stack, reportSummary) : this.getMeasureLevelScopeIncludeOne(env, stack, otherSummary))));
            if (this.containsAllLowestLevels(scope)) {
                return null;
            }
            return scope;
        }
        scope = isExplicitMeasureRollUp ? (!flags[2] ? this.getMeasureLevelScopeOneDetail(env, stack, reportSummary, true) : this.getMeasureLevelScopeOneDetail(env, stack, otherSummary, true)) : (!flags[0] && !otherFlags[0] ? (!flags[2] ? this.getMeasureLevelScopeOneDetail(env, stack, reportSummary, true) : this.getMeasureLevelScopeOneDetail(env, stack, otherSummary, true)) : (flags[0] && otherFlags[0] ? this.getMeasureLevelScope(env, stack, false) : (!flags[0] ? (!flags[2] ? this.getMeasureLevelScopeOneDetail(env, stack, reportSummary, false) : this.getMeasureLevelScopeIncludeOne(env, stack, reportSummary)) : (!otherFlags[2] ? this.getMeasureLevelScopeOneDetail(env, stack, otherSummary, false) : this.getMeasureLevelScopeIncludeOne(env, stack, otherSummary)))));
        if (this.containsAllLowestLevels(scope)) {
            return null;
        }
        return scope;
    }

    protected boolean containsAllLowestLevels(ArrayList<ILevel> levelScope) {
        if (levelScope.isEmpty()) {
            return false;
        }
        List<IDimension> dims = levelScope.get(0).getDimension().getCube().getDimensions();
        for (IDimension dim : dims) {
            IHierarchy hier;
            List<ILevel> lvls;
            String nm;
            if (dim.isMeasuresDimension() || !(nm = dim.getName()).startsWith("TBdimension_") || (lvls = (hier = dim.getDefaultHierarchy()).getLevels()).isEmpty() || levelScope.contains(lvls.get(lvls.size() - 1))) continue;
            return false;
        }
        return true;
    }

    protected ArrayList<ILevel> getMeasureLevelScope(TabStreamUtil.WrapCommonObjects env, LinkedList<IXQEQueryNode> stack, boolean include) {
        ArrayList<ILevel> scope = new ArrayList<ILevel>();
        for (IXQEQueryNode node : stack) {
            V5DataItemToLevelWrapper level = this.getLevelWrapper(env, node, include);
            if (level == null) continue;
            scope.add(level);
        }
        return scope;
    }

    protected ArrayList<ILevel> getMeasureLevelScopeIncludeOne(TabStreamUtil.WrapCommonObjects env, LinkedList<IXQEQueryNode> stack, IXQEQueryNode include) {
        ArrayList<ILevel> scope = new ArrayList<ILevel>();
        for (IXQEQueryNode node : stack) {
            V5DataItemToLevelWrapper level;
            boolean b = false;
            if (node.equals(include)) {
                b = true;
            }
            if ((level = this.getLevelWrapper(env, node, b)) == null) continue;
            scope.add(level);
        }
        return scope;
    }

    protected ArrayList<ILevel> getMeasureLevelScopeOneDetail(TabStreamUtil.WrapCommonObjects env, LinkedList<IXQEQueryNode> stack, IXQEQueryNode include, boolean b) {
        ArrayList<ILevel> scope = new ArrayList<ILevel>();
        for (IXQEQueryNode node : stack) {
            V5DataItemToLevelWrapper level = null;
            if (node.equals(include)) {
                boolean[] bret = new boolean[]{false};
                level = this.getDetailLevelWrapper(env, node, bret);
                if (level == null && bret[0]) {
                    return null;
                }
            } else {
                level = this.getLevelWrapper(env, node, b);
            }
            if (level == null) continue;
            scope.add(level);
        }
        return scope;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String flag = (String)node.getPropertyValue("wrapTo");
        if (flag != null && flag.equals("TBAggregate_")) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "need to create external rollUp for report summary.", trace);
        } else {
            this.traceNodeCondition(status, "don't create external rollUp for report summary.", trace);
        }
        return status;
    }
}

