/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;

public final class DecomposeV5DataItemToMeasureCalculation
extends Transformation {
    public DecomposeV5DataItemToMeasureCalculation() {
        this.mName = "Decompose the fact V5DataItem with aggregate=calculated.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getPropertyValue("needDecompose") == Boolean.TRUE) {
            node.removeProperty("needDecompose");
        } else {
            node.removeProperty("wrapTo");
        }
        V5DataItem v5DataItem = (V5DataItem)node;
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, (V5Query)v5DataItem.getAncestorOfType(101006));
        TabStreamUtil.decomposeExpression(env, node.getChild(0), false, v5DataItem.getNameProperty(), 1, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String flag = (String)node.getPropertyValue("wrapTo");
        if (flag != null && flag.equals("calculated")) {
            status = true;
        }
        if (!status) {
            boolean bl = status = node.getPropertyValue("needDecompose") == Boolean.TRUE;
        }
        if (status) {
            this.traceNodeCondition(status, "need to decompose the fact V5DataItem in relatioanl crosstab to measure calculation.", trace);
        } else {
            this.traceNodeCondition(status, "don't decompose fact V5DataItem to measure calculation.", trace);
        }
        return status;
    }
}

