/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class PushDetailFilterToListQuery
extends Transformation {
    public PushDetailFilterToListQuery() {
        this.mName = "Push detail filter from crosstab query to list query.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DetailFilter filter = (V5DetailFilter)node;
        if (filter.isOLAPConstruct()) {
            filter.setPropertyValue("wrapTo", "none");
            return;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        V5Source src = v5Query.getV5Source();
        CubeWrapper cube = (CubeWrapper)src.getPropertyValue("needTabularStream");
        V5QuerySet querySet = (V5QuerySet)v5Query.getAncestorOfType(101002);
        String subName = cube.getTabularResultSetName();
        V5Query subQuery = querySet.getV5Query(subName);
        subQuery.addChild(factory.deepCopyNode(node));
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Object flag = node.getPropertyValue("wrapTo");
        if (flag == null) {
            V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
            V5Source src = v5Query.getV5Source();
            Object cube = src.getPropertyValue("needTabularStream");
            status = cube instanceof CubeWrapper;
        }
        if (status) {
            this.traceNodeCondition(status, "need to push the detail filter to list query.", trace);
        } else {
            this.traceNodeCondition(status, "can't push the detail filter to list query.", trace);
        }
        return status;
    }
}

