/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveGroupSortSameAsAncestorValueSet
extends Transformation {
    public RemoveGroupSortSameAsAncestorValueSet() {
        this.mName = "Remove groupSort referencing the same V5DataItem as the ancestor V5ValueSet.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101056};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (v5QRD != null && v5QRD.getPropertyValue("tabstreamDefinition") != null) {
            status = this.sortItemReferenceSameV5DataItemAsAncestorValueSet(node);
        }
        if (status) {
            this.traceNodeCondition(status, "need to remove the useless sort item.", trace);
        } else {
            this.traceNodeCondition(status, "can't remove sort item.", trace);
        }
        return status;
    }

    protected boolean sortItemReferenceSameV5DataItemAsAncestorValueSet(IXQEQueryNode node) {
        String refName = ((V5SortItem)node).getRefDataItem();
        IXQEQueryNode currentEdgeGroup = node.getAncestorOfType(101050);
        if (currentEdgeGroup == null) {
            return false;
        }
        for (IXQEQueryNode ancestorEdgeGroup = currentEdgeGroup.getAncestorOfType(101050); ancestorEdgeGroup != null; ancestorEdgeGroup = ancestorEdgeGroup.getAncestorOfType(101050)) {
            V5ValueSet valueSet = (V5ValueSet)ancestorEdgeGroup.getFirstChildByType(101057);
            if (!valueSet.getRefDataItemProperty().equals(refName)) continue;
            return true;
        }
        return false;
    }
}

