/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream.dmrtorel;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import java.util.List;

public class FinalizeDMRtoRelationalQuery
extends Transformation {
    public FinalizeDMRtoRelationalQuery() {
        this.mName = "FinalizeDMRtoRelationalQuery";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] detailFilters;
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        V5Source source = query.getV5Source();
        query.setPropertyValue("isDMR", Boolean.FALSE);
        if (qrd.getNumberChildrenOfType(101049) <= 1) {
            query.setPropertyValue("isTabular", true);
        } else {
            source.setNeedTabularStream();
            query.setPropertyValue("isRelStyle", true);
        }
        query.removeProperty("containsDMRPushedDetailFilters");
        List<IXQEQueryNode> cubes = source.getDescendantsOfTypeOrdered(1007, false);
        for (IXQEQueryNode cube : cubes) {
            source.detachChild(cube);
        }
        for (IXQEQueryNode filter : detailFilters = query.getV5DetailFilters()) {
            filter.removeProperty("containsDMRPushedDetailFilters");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        if (Boolean.TRUE == query.getPropertyValue("containsDMRPushedDetailFilters")) {
            this.traceNodeCondition(true, "Query is flagged as DMR to relational.", environment.getTrace());
            return true;
        }
        this.traceNodeCondition(false, "Query is not as DMR to relational.", environment.getTrace());
        return false;
    }
}

