/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.todeprecate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Fact;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class TransferV5DimensionInfo
extends Transformation {
    public TransferV5DimensionInfo(int passNumber) {
        this.mName = "Transfer dimensionInfo";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101028};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TreeMap<String, V5DataItem> factItems = new TreeMap<String, V5DataItem>();
        this.getFactItemsNeedTransferred(node, factItems);
        for (Map.Entry<String, V5DataItem> e : factItems.entrySet()) {
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_transferDimensionInfo, e.getKey()));
            e.getValue().setPropertyValue("factItem", Boolean.TRUE);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        TreeMap<String, V5DataItem> factItems = new TreeMap<String, V5DataItem>();
        this.getFactItemsNeedTransferred(node, factItems);
        boolean bl = status = !factItems.isEmpty();
        if (status) {
            this.traceQueryCondition(status, "need to transfer dimensionInfo.", trace);
        } else {
            this.traceQueryCondition(status, "no need to transfer dimensionInfo.", trace);
        }
        return status;
    }

    protected void getFactItemsNeedTransferred(IXQEQueryNode node, TreeMap<String, V5DataItem> factItems) {
        IXQEQueryNode[] facts;
        IXQEQueryNode parent = node.getParent();
        if (parent == null || parent.getType() != 101006) {
            return;
        }
        V5Query query = (V5Query)parent;
        HashSet<String> factItemNames = new HashSet<String>();
        for (IXQEQueryNode aFact : facts = node.getChildrenOfType(101037)) {
            V5Fact v5Fact = (V5Fact)aFact;
            factItemNames.add(v5Fact.getRefDataItem());
        }
        if (factItemNames.isEmpty()) {
            return;
        }
        V5Selection select = query.getV5Selection();
        for (String aFactItem : factItemNames) {
            V5DataItem dataItem = select.getDataItemByRefName(aFactItem);
            if (dataItem == null) continue;
            boolean bSetFact = false;
            String rollUp = dataItem.getRollupAggregateProperty();
            if (rollUp == null || rollUp.equals("automatic")) {
                String aggr = dataItem.getAggregateProperty();
                if (aggr == null || aggr.equals("automatic") || aggr.equals("none")) {
                    bSetFact = true;
                }
            } else if (rollUp.equals("none")) {
                bSetFact = true;
            }
            if (!bSetFact || factItems.containsKey(aFactItem)) continue;
            factItems.put(aFactItem, dataItem);
        }
    }
}

