/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ValidateMemberDetailFilters
extends AbstractV5ToCogMDXTransformation {
    private static final int[] EXPRESSIONTYPES = new int[]{201011, 201013};

    public ValidateMemberDetailFilters() {
        this.mName = "Validate member detail filters.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1010};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int aSeverity = 1;
        IXQEQueryNode[] expressions = node.getDescendantsOfTypes(EXPRESSIONTYPES, false);
        for (int j = 0; j < expressions.length; ++j) {
            IXQEQueryNode expression = expressions[j];
            if (expression.getType() == 201013 && (((V5ComparisonExpression)expression).getSubType() != 2 && ((V5ComparisonExpression)expression).getSubType() != 3 || !this.validateRHSOfExpression(expression))) continue;
            this.validateLHSRHSConsistencyOfExpression(expression, true);
            String invalidNode = this.validateLHSOfExpression(expression);
            if (invalidNode == null) continue;
            XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_LeftHandSideOfMemberComparisonNotALevel, invalidNode, node);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
        }
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] expressions;
        XQETrace trace = environment.getTrace();
        for (IXQEQueryNode expression : expressions = node.getDescendantsOfTypes(EXPRESSIONTYPES, false)) {
            if (expression.getType() == 201011) {
                if (this.validateLHSOfExpression(expression) != null) {
                    this.traceQueryCondition(true, "The left-hand side of the IN expression does not contain a level reference.", trace);
                    return true;
                }
                if (this.validateLHSRHSConsistencyOfExpression(expression, false)) continue;
                this.traceQueryCondition(true, "The left-hand side and the right-hand side of the IN expression have to belong to same hierarchy and level.", trace);
                return true;
            }
            if (((V5ComparisonExpression)expression).getSubType() != 2 && ((V5ComparisonExpression)expression).getSubType() != 3 || !this.validateRHSOfExpression(expression)) continue;
            if (this.validateLHSOfExpression(expression) != null) {
                this.traceQueryCondition(true, "The left-hand side of the comparison expression does not contain a level reference.", trace);
                return true;
            }
            if (this.validateLHSRHSConsistencyOfExpression(expression, false)) continue;
            this.traceQueryCondition(true, "The left-hand side and the right-hand side of the comparison expression have to belong to same hierarchy and level.", trace);
            return true;
        }
        this.traceQueryCondition(false, "Not a member detail filter or member detail filter is valid.", trace);
        return false;
    }

    private boolean validateRHSOfExpression(IXQEQueryNode expression) {
        IXQEQueryNode[] children = expression.getChildren();
        for (int i = 1; i < children.length; ++i) {
            int type = children[i].getType();
            if (type == 201117 || children[i].isOfCategory(201122)) continue;
            return false;
        }
        return true;
    }

    private String validateLHSOfExpression(IXQEQueryNode expression) {
        if (expression.getNumberChildren() != 0) {
            if ((expression = expression.getChild(0)).getType() == 201113) {
                return null;
            }
            if (expression.getType() == 201098 && expression.getNumberChildren() == 2) {
                expression = expression.getChild(1);
            }
            if (expression.getType() == 201086 && expression.getNumberChildren() == 1) {
                expression = expression.getChild(0);
            }
            if (expression.getType() == 201116 && ((V5BoundModelIdentifier)expression).getMetadata().getObjectType() == MetadataType.LEVEL) {
                return null;
            }
            if (expression.getType() == 201116 && ((V5BoundModelIdentifier)expression).getMetadata().getObjectType() == MetadataType.QUERY_ITEM && ((IQueryItem)((V5BoundModelIdentifier)expression).getMetadata()).getLevel() != null) {
                return null;
            }
            if (expression.getNumberChildren() == 1 && ((V5SimpleNode)expression).isCoercion()) {
                expression = expression.getChild(0);
            }
        }
        V5DataItem dataItem = (V5DataItem)ASTUtil.getFirstNodeOfTypeFromQueryLineage(expression, 101003);
        String param = null;
        if (dataItem == null) {
            param = ((V5SimpleNode)expression).getNativeName();
            if (param == null) {
                param = "unknown";
            }
        } else {
            param = dataItem.getNameProperty();
        }
        return param;
    }

    private boolean validateLHSRHSConsistencyOfExpression(IXQEQueryNode expression, boolean throwException) {
        MDXHierInfo hierInfo = null;
        if (expression.getChild(0).isOfCategory(201120)) {
            hierInfo = ((V5SimpleNode)expression.getChild(0)).getHierarchyInfo();
        }
        if (hierInfo != null && hierInfo.getNumProjectedHierarchies() == 1) {
            IHierarchy hierarchyOfBoundModel = hierInfo.getProjectedHierarchy(0);
            int iStart = 1;
            if (expression.getChild(1).getType() == 201101) {
                expression = expression.getChild(1);
                --iStart;
            }
            for (int i = iStart; i < expression.getNumberChildren(); ++i) {
                IXQEQueryNode v5Child = expression.getChild(i);
                if (v5Child.getType() != 201117 && v5Child.isOfCategory(201122)) continue;
                hierInfo = null;
                IHierarchy hierarchyOfBoundMUN = null;
                if (v5Child.isOfCategory(201120)) {
                    hierInfo = ((V5SimpleNode)v5Child).getHierarchyInfo();
                }
                if (hierInfo != null && hierInfo.getNumProjectedHierarchies() == 1) {
                    hierarchyOfBoundMUN = hierInfo.getProjectedHierarchy(0);
                }
                if (hierarchyOfBoundModel == null || hierarchyOfBoundMUN == null || hierarchyOfBoundModel.getV5UniqueName().equals(hierarchyOfBoundMUN.getV5UniqueName())) continue;
                if (throwException) {
                    String name = "IN";
                    if (expression.getType() == 201013) {
                        name = "EQ";
                        if (((V5ComparisonExpression)expression).getSubType() == 3) {
                            name = "NE";
                        }
                    }
                    throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleHierarchiesDetailFilter, (Object)hierarchyOfBoundModel.getV5UniqueName(), (Object)hierarchyOfBoundMUN.getV5UniqueName(), (Object)name);
                }
                return false;
            }
        }
        return true;
    }
}

