/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class ConvertV5InExpressionOnPropertyToMDX
extends AbstractV5ToCogMDXTransformation {
    private static final String TRACE1 = "a propery comparison.";

    public ConvertV5InExpressionOnPropertyToMDX() {
        this.mName = "Transform a V5InExpression node with a MDXProperty left operand into a CogMDXIn node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean reverseCondition = false;
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 201003 && ((V5LogicalExpression)parent).getSubType() == 2) {
            reverseCondition = true;
            parent.extract();
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXBooleanExpression mdxBooleanNode = MDXBuilder.convertV5InExpressionIntoMDX((V5InExpression)node, nodeFactory, reverseCondition);
        node.getParent().exchangeChildNode(node, mdxBooleanNode, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        StringBuilder msgStr = null;
        if (trace.getTraceLevel() != 0) {
            new StringBuilder();
        }
        status = ConvertV5InExpressionOnPropertyToMDX.isValueComparison(node, msgStr);
        if (msgStr != null) {
            this.traceQueryCondition(status, msgStr.toString(), trace);
        }
        return status;
    }

    public static boolean isValueComparison(IXQEQueryNode node, StringBuilder msgStr) {
        boolean status = ConvertV5InExpressionOnPropertyToMDX.isPropertyComparison(node, msgStr);
        if (!status) {
            IXQEQueryNode leftOperand = node.getChild(0);
            status = leftOperand.isOfCategory(1061);
            if (msgStr != null) {
                if (status) {
                    msgStr.delete(0, msgStr.length());
                    msgStr.append("The V5InExpression node is a value comparison expression.");
                } else {
                    msgStr.append("The V5InExpression node is not a value comparison expression.");
                }
            }
        }
        return status;
    }

    public static boolean isPropertyComparison(IXQEQueryNode node, StringBuilder msgStr) {
        return ConvertV5InExpressionOnPropertyToMDX.isPropertyComparison(node, msgStr, null);
    }

    public static boolean isPropertyComparison(IXQEQueryNode node, StringBuilder msgStr, CogMDXProperties cogMDXProperties) {
        IXQEQueryNode leftOperand;
        boolean status = true;
        if (msgStr != null) {
            msgStr.append("The node is");
        }
        if (cogMDXProperties == null && (status = (leftOperand = node.getChild(0)).isOfCategory(1016))) {
            cogMDXProperties = (CogMDXProperties)leftOperand;
        }
        if (status) {
            MDXLevelInfo propertyLevels;
            if (msgStr != null) {
                msgStr.append(" ");
                msgStr.append(TRACE1);
            }
            if (!(node.getNumberChildren() == 2 && node.getChild(1).isOfCategory(1061) || (propertyLevels = cogMDXProperties.getLevelInfo()) == null || propertyLevels.getHierarchyInfo().getNumProjectedHierarchies() == 0)) {
                for (int i = 1; i < node.getNumberChildren(); ++i) {
                    if (node.getChild(i).isOfCategory(1016)) {
                        MDXLevelInfo rightOperandLevels = ((CogMDXProperties)node.getChild(i)).getLevelInfo();
                        if (propertyLevels.compareProjectedLevels(rightOperandLevels)) continue;
                        status = false;
                        if (msgStr != null) {
                            msgStr.append(" ");
                            msgStr.append("Is a comparison of two properties associated to different levels.");
                        }
                    } else {
                        if (node.getChild(i).isOfCategory(1061) || node.getChild(i).isOfCategory(1129)) continue;
                        status = false;
                        if (msgStr != null) {
                            msgStr.append(" ");
                            msgStr.append("The V5InExpression node contains at least one invalid operand.");
                        }
                    }
                    break;
                }
            }
        } else if (msgStr != null) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append(TRACE1);
        }
        return status;
    }
}

