/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class ConvertV5InToCogMDXIn
extends Transformation {
    public ConvertV5InToCogMDXIn() {
        this.mName = "Convert the V5 IN operator to the CogMDXIn operator.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (!node.getChild(1).isOfCategory(1021)) {
            IXQEQueryNode mdxSetNode = nodeFactory.createNode(1039);
            IXQEQueryNode[] children = node.getChildren();
            for (int i = 1; i < children.length; ++i) {
                children[i].move(mdxSetNode);
            }
            node.addChild(mdxSetNode);
        }
        IXQEQueryNode cogMDXInNode = nodeFactory.createNode(1029);
        node.getParent().exchangeChildNode(node, cogMDXInNode, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode detailFilterNode = node.getAncestorOfType(1010);
        if (detailFilterNode != null) {
            if (((CogMDXDetailFilter)detailFilterNode).pushDetailFilterToRelationalProvider()) {
                this.traceQueryCondition(false, "Detail filter pushed to the relational query, not applicable.", trace);
                return false;
            }
            status = true;
            this.traceQueryCondition(status, "The node is within a Cog MDX Detail Filter.", trace);
        } else {
            this.traceQueryCondition(status, "The node is not within a Cog MDX Detail Filter.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode leftExpression;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int nbrChildren = node.getNumberChildren();
        if (nbrChildren >= 2 && (leftExpression = node.getChild(0)).isOfCategory(1021)) {
            MDXHierInfo leftExprLevelInfo = ((AbstractMDXNode)leftExpression).getHierarchyInfo();
            IXQEQueryNode rightExpression = node.getChild(1);
            if (rightExpression.isOfCategory(1021)) {
                MDXHierInfo rightExprLevelInfo = ((AbstractMDXNode)rightExpression).getHierarchyInfo();
                if (leftExprLevelInfo.getNumProjectedHierarchies() == 1 && leftExprLevelInfo.compareProjectedHierarchies(rightExprLevelInfo)) {
                    status = true;
                }
            } else {
                int idx;
                for (idx = 1; idx < nbrChildren && node.getChild(idx).isOfCategory(1022); ++idx) {
                    MDXHierInfo rigthExprLevelInfo = ((AbstractMDXNode)node.getChild(idx)).getHierarchyInfo();
                    if (leftExprLevelInfo.getNumProjectedHierarchies() != 1 || !leftExprLevelInfo.compareProjectedHierarchies(rigthExprLevelInfo)) break;
                }
                if (idx == nbrChildren) {
                    status = true;
                }
            }
        }
        if (status) {
            this.traceNodeCondition(status, "The V5 IN operator contains operands that are properly coerced.", trace);
        } else {
            this.traceNodeCondition(status, "The V5 IN operator contains operands that are not properly coerced.", trace);
        }
        return status;
    }
}

