/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class ConvertV5MemberToMDXCalculatedMember
extends AbstractV5ToCogMDXTransformation {
    private static final int CHILDPOS0 = 0;
    private static final int CHILDPOS1 = 1;
    private static final int CHILDPOS2 = 2;
    private static final int CHILDPOS3 = 3;
    private static final int V5MEMBERFUN_MAX_NUM_CHILDREN = 4;
    private static final String VALID_EXPRESSION = "The V5 Member function is a valid supported expression.";
    private static final String STRING_UNDERSCORE = "_";

    public ConvertV5MemberToMDXCalculatedMember() {
        this.mName = "Convert V5 Member function to a MDX Calculated Member on a hierarchy.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201085};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean asReportSummary;
        String format;
        IXQEQueryNode captionNode;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        V5MemberFunction v5MemberFunction = (V5MemberFunction)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        StringBuilder sb = new StringBuilder("_V5M");
        String memberMun = null;
        if (node.getNumberChildren() >= 2) {
            IXQEQueryNode munNode = node.getChild(1);
            if (munNode.getType() == 1127 && (memberMun = ((MDXStringConstant)munNode).getConstantValue()).length() > 0) {
                sb.append(STRING_UNDERSCORE + memberMun);
            }
        } else {
            V5DataItemRef v5DataItemRef = (V5DataItemRef)node.getAncestorOfType(101015);
            if (v5DataItemRef != null && v5DataItemRef.getDataItemRefProperty() != null && !v5DataItemRef.getDataItemRefProperty().isEmpty()) {
                sb.append(STRING_UNDERSCORE + v5DataItemRef.getDataItemRefProperty());
            }
        }
        String mun = sb.toString();
        String memberCaption = null;
        if (node.getNumberChildren() >= 3 && (captionNode = node.getChild(2)).getType() == 1127) {
            memberCaption = ((MDXStringConstant)captionNode).getConstantValue();
        }
        if (memberCaption == null) {
            memberCaption = memberMun;
        }
        IHierarchy hierarchy = null;
        V5ValueSet v5ValueSet = (V5ValueSet)node.getAncestorOfType(101057);
        String refDataItem = null;
        if (v5ValueSet != null) {
            refDataItem = v5ValueSet.getRefDataItemProperty();
        }
        boolean isPlannerHierarchy = true;
        boolean isUserHierarchy = false;
        if (node.getNumberChildren() == 4) {
            V5EdgeGroup v5EdgeGroup;
            hierarchy = ((AbstractMDXHierarchy)node.getChild(3)).getHierarchy();
            isPlannerHierarchy = false;
            boolean bl = isUserHierarchy = !v5MemberFunction.isPlannerV5MemberFn();
            if (hierarchy.isShell() && (v5EdgeGroup = (V5EdgeGroup)v5ValueSet.getAncestorOfType(101050)) != null && v5EdgeGroup.getPropertyHierarchy() != null && !v5EdgeGroup.getPropertyHierarchy().equals(hierarchy) && v5EdgeGroup.isHierarchyDepthRedone()) {
                hierarchy = v5EdgeGroup.getPropertyHierarchy();
            }
        } else if (!mdxQuery.isListReport() && refDataItem != null) {
            IXQEQueryNode[] grandParentHierarchy;
            V5EdgeGroup grandParentV5Grp;
            V5EdgeGroup v5Grp = (V5EdgeGroup)node.getAncestorOfType(101050);
            hierarchy = v5Grp.getPropertyHierarchy();
            if (hierarchy != null && hierarchy.isShell() && (grandParentV5Grp = (V5EdgeGroup)v5Grp.getAncestorOfType(101050)) != null && (grandParentHierarchy = grandParentV5Grp.getPropertyHierarchy()).isShell() && grandParentHierarchy.equals(hierarchy)) {
                hierarchy = null;
            }
            IXQEQueryNode[] childEdgeGroups = v5ValueSet.getChildrenOfType(101050);
            if (v5ValueSet.getParent() == v5Grp && childEdgeGroups.length > 0) {
                for (IXQEQueryNode v5GrpChild : childEdgeGroups) {
                    IHierarchy nestedHierarchy = ((V5EdgeGroup)v5GrpChild).getPropertyHierarchy();
                    if (hierarchy != nestedHierarchy) continue;
                    hierarchy = null;
                    break;
                }
            }
            if (hierarchy == null) {
                hierarchy = ConvertV5MemberToMDXCalculatedMember.generateShellHierarchy(mdxQuery, v5ValueSet);
            }
            if (hierarchy == null) {
                v5ValueSet.throwInternalError("Fail to get a dummy hierarchy");
            }
        }
        if (hierarchy == null) {
            IXQEQueryNode nodeParent = node.getParent();
            if (v5ValueSet == null || nodeParent.getNumberChildren() == 1 && nodeParent.getType() == 201101) {
                ICube cube = mdxQuery.getReferencedCube();
                hierarchy = cube.getMeasuresHierarchy();
                isPlannerHierarchy = false;
            } else {
                hierarchy = ConvertV5MemberToMDXCalculatedMember.generateShellHierarchy(mdxQuery, v5ValueSet);
            }
        }
        int solveOrder = 0;
        if (v5MemberFunction.getSolveOrder() != null) {
            solveOrder = v5MemberFunction.getSolveOrder();
        }
        ILevel level = (ILevel)node.getPropertyValue("level");
        MDXCalculatedMemberReference mdxCM = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, hierarchy, mun, (AbstractMDXNode)node.detachChild(0), solveOrder);
        if (level != null) {
            mdxCM.getDefinition().setLevel(level);
        }
        if ((format = (String)node.getPropertyValue("format")) != null) {
            mdxCM.getDefinition().setPropertyValue("FORMAT_STRING", format);
        }
        mdxCM.getDefinition().setV5Caption(memberCaption);
        mdxCM.getDefinition().setV5Name(memberMun);
        mdxCM.getDefinition().setV5ParsedNodeId(v5MemberFunction.getV5ParsedNodeId());
        mdxCM.getDefinition().setPlannerHierarchy(isPlannerHierarchy);
        mdxCM.getDefinition().setUserHierarchy(isUserHierarchy);
        if (v5MemberFunction.isAbsoluteSolveOrder().booleanValue()) {
            mdxCM.getDefinition().setAbsoluteSolveOrder(v5MemberFunction.isAbsoluteSolveOrder());
        }
        node.getParent().exchangeChildNode(node, mdxCM, false);
        mdxCM.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        mdxCM.getDefinition().setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        if (!v5MemberFunction.isQueryCalculation()) {
            mdxCM.setIsV5CalculatedMember();
        }
        mdxCM.setIsQueryCalculation(v5MemberFunction.isQueryCalculation());
        if (Boolean.TRUE.equals(v5MemberFunction.getPropertyValue("createdFromROLAPCalcMember"))) {
            mdxCM.getDefinition().setPropertyValue("createdFromROLAPCalcMember", Boolean.TRUE);
        }
        if (v5ValueSet != null && (asReportSummary = (Boolean)v5ValueSet.getPropertyValue("treatedAsReportSummary")) != null && asReportSummary.equals(true)) {
            mdxCM.getDefinition().setPropertyValue("treatedAsReportSummary", asReportSummary);
        }
    }

    public static IHierarchy generateShellHierarchy(MDXQuery mdxQuery, V5ValueSet v5ValueSet) {
        int depth = v5ValueSet.getDepth();
        Integer iDepth = XQEIntegerPool.getInteger(depth);
        IXQEQueryNode v5Edge = v5ValueSet.getAncestorOfType(101049);
        String hierName = MDXQuery.getShellHierarchyName((V5Edge)v5Edge, iDepth);
        IHierarchy hierarchy = mdxQuery.getShellHierarchy(hierName, depth);
        return hierarchy;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode valueExpr;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int nbrChildren = node.getNumberChildren();
        if (nbrChildren == 0 || nbrChildren > 4) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidChildNode, node.getNodeTypeName());
        }
        if (nbrChildren >= 1 && nbrChildren <= 4 && ((valueExpr = node.getChild(0)).isOfCategory(1061) || valueExpr.isOfCategory(1022) || valueExpr.isOfCategory(1068))) {
            if (nbrChildren == 2) {
                if (this.isString(node.getChild(1))) {
                    status = true;
                    this.traceNodeCondition(status, VALID_EXPRESSION, trace);
                }
            } else if (nbrChildren == 3) {
                if (this.isString(node.getChild(1)) && this.isString(node.getChild(2))) {
                    status = true;
                    this.traceNodeCondition(status, VALID_EXPRESSION, trace);
                }
            } else if (nbrChildren == 4) {
                if (this.isString(node.getChild(1)) && this.isString(node.getChild(2)) && node.getChild(3).isOfCategory(1072)) {
                    status = true;
                    this.traceNodeCondition(status, "The V5 Member function is a valid supported expression, for the specified hierarchy.", trace);
                }
            } else {
                status = true;
                this.traceNodeCondition(status, VALID_EXPRESSION, trace);
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "The V5 Member function is not a valid supported expression.", trace);
        }
        return status;
    }

    private boolean isString(IXQEQueryNode node) {
        boolean bString = false;
        if (node.isOfCategory(1061) && ((AbstractMDXValueExpression)node).isString()) {
            bString = true;
        }
        return bString;
    }
}

